/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.ldap;

import de.deepamehta.ldap.ApacheLDAP$$Lambda$1;
import de.deepamehta.ldap.ApacheLDAP$$Lambda$2;
import de.deepamehta.ldap.Configuration;
import de.deepamehta.ldap.LDAP;
import de.deepamehta.ldap.PluginLog;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;

class ApacheLDAP
implements LDAP {
    private final Configuration configuration;
    private final PluginLog pluginLog;
    private final LdapConnectionConfig defaultConnectionConfig;

    ApacheLDAP(Configuration configuration, PluginLog pluginLog) {
        this.configuration = configuration;
        this.pluginLog = pluginLog;
        this.defaultConnectionConfig = this.createConfig(configuration.manager, configuration.password);
    }

    private LdapConnectionConfig createConfig(String user, String password) {
        LdapConnectionConfig cc = new LdapConnectionConfig();
        cc.setName(user);
        cc.setCredentials(password);
        cc.setLdapHost(this.configuration.server);
        cc.setLdapPort(Integer.parseInt(this.configuration.port));
        if (this.configuration.protocol == Configuration.ProtocolType.LDAPS) {
            cc.setUseSsl(true);
        } else if (this.configuration.protocol == Configuration.ProtocolType.STARTTLS) {
            cc.setUseTls(true);
        }
        return cc;
    }

    private void whenBound(String userDn, String password, LdapAction action) {
        LdapNetworkConnection connection = new LdapNetworkConnection(this.defaultConnectionConfig);
        try {
            connection.bind(userDn, password);
            action.run((LdapConnection)connection);
        }
        catch (LdapException le) {
            throw new RuntimeException("Error opening LDAP connection.", le);
        }
        finally {
            this.closeQuietly((Closeable)connection);
        }
    }

    @Override
    public boolean checkCredentials(String user, String password) {
        AtomicBoolean result = new AtomicBoolean(false);
        this.whenBound(this.configuration.manager, this.configuration.password, ApacheLDAP$$Lambda$1.lambdaFactory$(this, user, result, password));
        return result.get();
    }

    private void closeQuietly(Closeable cursor) {
        if (cursor != null) {
            try {
                cursor.close();
            }
            catch (IOException ioe) {
                this.pluginLog.actionWarning("Exception when closing resource.", ioe);
            }
        }
    }

    @Override
    public boolean createUser(String user, String password, LDAP.CompletableAction actionOnSuccess) {
        return false;
    }

    @Override
    public boolean changePassword(String user, String password) {
        return false;
    }

    @Override
    public boolean deleteUser(String user, String password) {
        AtomicBoolean result = new AtomicBoolean(false);
        String userDN = String.format("%s=%s,%s", this.configuration.userAttribute, user, this.configuration.userBase);
        this.whenBound(userDN, password, ApacheLDAP$$Lambda$2.lambdaFactory$(this, userDN, result));
        return result.get();
    }

    static /* synthetic */ void lambda$deleteUser$1(ApacheLDAP this_, String userDN, AtomicBoolean result, LdapConnection connection) {
        try {
            connection.delete(userDN);
            result.set(true);
        }
        catch (LdapException e) {
            this_.pluginLog.actionWarning("Attempt to delete user entry lead to exception", e);
        }
    }

    static /* synthetic */ void lambda$checkCredentials$0(ApacheLDAP this_, String user, AtomicBoolean result, String password, LdapConnection connection) {
        Entry entry;
        DefaultAttribute userPassword;
        EntryCursor cursor;
        block9: {
            block8: {
                block7: {
                    String searchFilter = StringUtils.isEmpty((String)this_.configuration.userFilter) ? String.format("(%s=%s)", this_.configuration.userAttribute, user) : String.format("(&(%s)(%s=%s))", this_.configuration.userFilter, this_.configuration.userAttribute, user);
                    this_.pluginLog.actionHint("Complete filter expression for user lookup: %s", searchFilter);
                    this_.pluginLog.actionHint("Search base is: %s", this_.configuration.userBase);
                    cursor = null;
                    userPassword = new DefaultAttribute("userPassword");
                    cursor = connection.search(this_.configuration.userBase, searchFilter, SearchScope.ONELEVEL, new String[]{userPassword.getId()});
                    if (cursor.next()) break block7;
                    this_.pluginLog.actionWarning("Lookup using search filter was empty.", null);
                    this_.closeQuietly((Closeable)cursor);
                    return;
                }
                entry = (Entry)cursor.get();
                if (!cursor.next()) break block8;
                this_.pluginLog.actionWarning("Ambiguity in LDAP CN query: Matched multiple users for the accountName", null);
                this_.closeQuietly((Closeable)cursor);
                return;
            }
            this_.pluginLog.actionHint("Lookup using search filter returned a single non-empty result.", new Object[0]);
            if (entry.contains(new Attribute[]{userPassword})) break block9;
            this_.pluginLog.actionWarning("Result does not contains the requested userPassword attribute.", null);
            this_.closeQuietly((Closeable)cursor);
            return;
        }
        try {
            result.set(PasswordUtil.compareCredentials((byte[])password.getBytes(), (byte[])entry.get(userPassword.getId()).get().getBytes()));
            this_.pluginLog.actionHint("Password comparison: %s", result.get() ? "SUCEEDED" : "FAILED");
            this_.closeQuietly((Closeable)cursor);
        }
        catch (CursorException | LdapException le) {
            try {
                throw new RuntimeException("Error while checking credentials.", le);
            }
            catch (Throwable throwable) {
                this_.closeQuietly((Closeable)cursor);
                throw throwable;
            }
        }
    }

    static interface LdapAction {
        public void run(LdapConnection var1);
    }
}

