/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.ldap.profile.feature.common.usecase;

import de.deepamehta.ldap.profile.model.Session;
import de.deepamehta.ldap.profile.repository.LdapRepository;

public class RunOnLdap {
    private final LdapRepository ldapRepository;

    public RunOnLdap(LdapRepository ldapRepository) {
        this.ldapRepository = ldapRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(String userName, LdapRunner runner) {
        Session session = this.ldapRepository.openConnection(userName);
        if (session == null) {
            throw new IllegalStateException("Unable to connect to LDAP.");
        }
        try {
            runner.run(session);
        }
        finally {
            this.ldapRepository.closeConnection(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T invoke(String userName, LdapRunnerWithReturnValue<T> runner) {
        Session session = this.ldapRepository.openConnection(userName);
        if (session == null) {
            throw new IllegalStateException("Unable to connect to LDAP.");
        }
        try {
            T t = runner.run(session);
            return t;
        }
        finally {
            this.ldapRepository.closeConnection(session);
        }
    }

    public static interface LdapRunnerWithReturnValue<T> {
        public T run(Session var1);
    }

    public static interface LdapRunner {
        public void run(Session var1);
    }
}

