/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.ldap;

import de.deepamehta.ldap.Configuration;
import de.deepamehta.ldap.LDAP;
import de.deepamehta.ldap.PluginLog;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.crypto.password.LdapShaPasswordEncoder;

class JndiLDAP
implements LDAP {
    private final Configuration configuration;
    private final PluginLog pluginLog;

    JndiLDAP(Configuration configuration, PluginLog log) {
        this.configuration = configuration;
        this.pluginLog = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createUser(String username, String password, LDAP.CompletableAction actionOnSuccess) {
        LdapContext ctx = null;
        try {
            ctx = this.connect();
            String encodedPassword = new LdapShaPasswordEncoder().encode((CharSequence)password);
            boolean bl = this.createUserImpl(ctx, username, encodedPassword) && actionOnSuccess.run(username);
            return bl;
        }
        finally {
            this.closeQuietly(ctx);
        }
    }

    private boolean createUserImpl(LdapContext ctx, String userName, String password) {
        String entryDN = String.format("%s=%s,%s", this.configuration.userAttribute, userName, this.configuration.userBase);
        BasicAttribute cn = new BasicAttribute("cn", userName);
        BasicAttribute sn = new BasicAttribute("sn", "deepamehta-ldap");
        BasicAttribute userPassword = new BasicAttribute("userPassword", password);
        BasicAttribute oc = new BasicAttribute("objectClass");
        oc.add("top");
        oc.add("person");
        oc.add("organizationalPerson");
        oc.add("inetOrgPerson");
        BasicAttributes entry = new BasicAttributes();
        entry.put(oc);
        entry.put(cn);
        entry.put(sn);
        entry.put(userPassword);
        try {
            ctx.createSubcontext(entryDN, (Attributes)entry);
        }
        catch (NamingException ne) {
            this.pluginLog.actionError("Unable to create user subcontext", ne);
            return false;
        }
        if (StringUtils.isNotEmpty((String)this.configuration.userMemberGroup)) {
            ModificationItem mi = new ModificationItem(1, new BasicAttribute("member", entryDN));
            try {
                ctx.modifyAttributes(this.configuration.userMemberGroup, new ModificationItem[]{mi});
            }
            catch (NamingException ne) {
                this.pluginLog.actionError("Membership attribute addition failed - rollback!", ne);
                try {
                    ctx.destroySubcontext(entryDN);
                }
                catch (NamingException ne2) {
                    this.pluginLog.actionError("Unable to rollback context creation!", ne2);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkCredentials(String username, String password) {
        String cn;
        String url;
        LdapContext ctx2;
        LdapContext ctx;
        block6: {
            this.pluginLog.actionHint("Checking credentials for user %s", username);
            ctx = null;
            ctx2 = null;
            url = this.configuration.getConnectionUrl();
            ctx = this.connect(url, this.configuration.manager, this.configuration.password, false);
            cn = this.lookupUserCn(ctx, username);
            if (cn != null) break block6;
            this.pluginLog.actionHint("User %s not found in LDAP", username);
            boolean bl = false;
            this.closeQuietly(ctx);
            this.closeQuietly(ctx2);
            return bl;
        }
        try {
            ctx2 = this.connect(url, cn, password, true);
            if (ctx == null) {
                this.pluginLog.actionHint("Provided credentials for user %s were wrong", username);
            }
            boolean bl = ctx2 != null;
            this.closeQuietly(ctx);
            this.closeQuietly(ctx2);
            return bl;
        }
        catch (NamingException e) {
            try {
                throw new RuntimeException("Checking LDAP credentials lead to exception", e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(ctx);
                this.closeQuietly(ctx2);
                throw throwable;
            }
        }
    }

    private String lookupUserCn(LdapContext ctx, String uid) throws NamingException {
        String searchFilter = StringUtils.isEmpty((String)this.configuration.userFilter) ? String.format("(%s=%s)", this.configuration.userAttribute, uid) : String.format("(&(%s)(%s=%s))", this.configuration.userFilter, this.configuration.userAttribute, uid);
        this.pluginLog.actionHint("Complete filter expression for user lookup: %s", searchFilter);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search(this.configuration.userBase, searchFilter, searchControls);
        this.pluginLog.actionHint("Search base is: %s", this.configuration.userBase);
        if (results.hasMoreElements()) {
            this.pluginLog.actionHint("Lookup using search filter returned non-empty result", new Object[0]);
            SearchResult searchResult = (SearchResult)results.nextElement();
            if (results.hasMoreElements()) {
                throw new RuntimeException("Ambiguity in LDAP CN query: Matched multiple users for the accountName");
            }
            return searchResult.getNameInNamespace();
        }
        this.pluginLog.actionWarning("Lookup using search filter was empty.", null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changePassword(String username, String password) {
        this.pluginLog.actionHint("Changing password for user %s", username);
        LdapContext ctx = null;
        try {
            ctx = this.connect();
            String encodedPassword = new LdapShaPasswordEncoder().encode((CharSequence)password);
            boolean bl = this.changePasswordImpl(ctx, username, encodedPassword);
            return bl;
        }
        finally {
            this.closeQuietly(ctx);
        }
    }

    private boolean changePasswordImpl(LdapContext ctx, String userName, String password) {
        String entryDN = String.format("%s=%s,%s", this.configuration.userAttribute, userName, this.configuration.userBase);
        ModificationItem mi = new ModificationItem(2, new BasicAttribute("userPassword", password));
        try {
            ctx.modifyAttributes(entryDN, new ModificationItem[]{mi});
        }
        catch (NamingException ne) {
            this.pluginLog.actionWarning("Attempt to modify userPassword attribute lead to exception", ne);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteUser(String user, String password) {
        this.pluginLog.actionHint("Changing password for user %s", user);
        if (this.checkCredentials(user, password)) {
            LdapContext ctx = null;
            try {
                ctx = this.connect();
                boolean bl = this.deleteUserImpl(ctx, user);
                return bl;
            }
            finally {
                this.closeQuietly(ctx);
            }
        }
        return false;
    }

    private boolean deleteUserImpl(LdapContext ctx, String userName) {
        String entryDN = String.format("%s=%s,%s", this.configuration.userAttribute, userName, this.configuration.userBase);
        try {
            ctx.unbind(entryDN);
        }
        catch (NamingException ne) {
            this.pluginLog.actionWarning("Attempt to delete user entry lead to exception", ne);
            return false;
        }
        return true;
    }

    private LdapContext connect() {
        return this.connect(this.configuration.getConnectionUrl(), this.configuration.manager, this.configuration.password, false);
    }

    private LdapContext connect(String serverUrl, String username, String password, boolean suppressNamingException) {
        this.pluginLog.actionHint("creating LDAP connection using URL %s and username %s", serverUrl, username);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.provider.url", serverUrl);
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.ldap.attributes.binary", "objectSID");
        if (this.configuration.loggingMode == Configuration.LoggingMode.DEBUG) {
            this.pluginLog.actionHint("Enabling detailed SSL logging", new Object[0]);
            System.setProperty("javax.net.debug", "all");
        }
        Control[] arr = new Control[]{};
        try {
            InitialLdapContext ctx = new InitialLdapContext(env, arr);
            this.pluginLog.actionHint("Initial context created", new Object[0]);
            if (this.configuration.protocol == Configuration.ProtocolType.STARTTLS) {
                this.pluginLog.actionHint("Attempting TLS negotiation (StartTLS protocol)", new Object[0]);
                StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                SSLSession session = tls.negotiate();
                this.pluginLog.actionHint("TLS negotiated successfully.", new Object[0]);
            }
            this.pluginLog.actionHint("Initial context usable", new Object[0]);
            return ctx;
        }
        catch (NamingException e) {
            if (suppressNamingException) {
                this.pluginLog.actionWarning("Attempting to connect to LDAP server lead to Exception", e);
                return null;
            }
            throw new RuntimeException("Attempting to connect to LDAP server lead to Exception", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not establish TLS connection. Connecting failed.", e);
        }
    }

    private void closeQuietly(LdapContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException ne) {
                this.pluginLog.actionWarning("Exception while closing connection", ne);
            }
        }
    }
}

