/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.ldap;

import de.deepamehta.accesscontrol.AccessControlService;
import de.deepamehta.accesscontrol.AuthorizationMethod;
import de.deepamehta.core.Topic;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.Inject;
import de.deepamehta.core.service.accesscontrol.Credentials;
import de.deepamehta.core.storage.spi.DeepaMehtaTransaction;
import de.deepamehta.ldap.Configuration;
import de.deepamehta.ldap.LDAP;
import de.deepamehta.ldap.LDAP$;
import de.deepamehta.ldap.PluginLog;
import de.deepamehta.ldap.PluginLog$;
import de.deepamehta.ldap.profile.service.ProfileService;
import de.deepamehta.ldap.profile.service.impl.ProfileServiceAccessControl;
import de.deepamehta.ldap.profile.service.impl.ProfileServiceImpl;
import de.deepamehta.ldap.service.LDAPPluginService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class LDAPPlugin
extends PluginActivator
implements AuthorizationMethod,
LDAPPluginService {
    private static Logger logger = Logger.getLogger(LDAPPlugin.class.getName());
    @Inject
    private AccessControlService acs;
    private Configuration configuration;
    private PluginLog pluginLog;
    private LDAP ldap;

    public void serviceArrived(Object service) {
        ((AccessControlService)service).registerAuthorizationMethod("LDAP", (AuthorizationMethod)this);
    }

    public void serviceGone(Object service) {
        ((AccessControlService)service).unregisterAuthorizationMethod("LDAP");
    }

    public void init() {
        try {
            this.configuration = Configuration.createFromProperties();
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing configuration", e);
        }
        this.pluginLog = PluginLog$.newInstance(this.configuration.loggingMode);
        this.pluginLog.configurationHint("Plugin configuration:\n%s", this.configuration.summary());
        if (!this.configuration.check(this.pluginLog)) {
            throw new RuntimeException("LDAP Plugin configuration is not correct. Please fix the issues mentioned in the log.");
        }
        this.configuration.compile();
        this.ldap = LDAP$.newInstance(this.configuration, this.pluginLog);
    }

    public Topic checkCredentials(Credentials cred) {
        if (this.ldap.checkCredentials(cred.username, cred.plaintextPassword)) {
            Topic username = this.lookupOrCreateUsernameTopic(cred.username);
            if (username != null) {
                this.pluginLog.actionHint("LDAP log-in successful for user %s", cred.username);
                return username;
            }
            this.pluginLog.actionError("Credentials in LDAP are OK but unable find or create username topic", null);
            return null;
        }
        this.pluginLog.actionError(String.format("Credential check for user %s failed.", cred.username), null);
        return null;
    }

    @Override
    public Topic createUser(Credentials cred) {
        if (!this.configuration.userCreationEnabled) {
            logger.warning("User creation is disabled in plugin configuration!");
            return null;
        }
        final AtomicReference usernameTopicRef = new AtomicReference();
        this.ldap.createUser(cred.username, cred.plaintextPassword, new LDAP.CompletableAction(){

            @Override
            public boolean run(String username) {
                Topic usernameTopic = null;
                try {
                    usernameTopic = LDAPPlugin.this.lookupOrCreateUsernameTopic(username);
                    boolean bl = usernameTopic != null;
                    return bl;
                }
                catch (Exception e) {
                    LDAPPlugin.this.pluginLog.actionError(String.format("Creating username %s failed but LDAP entry was already created. Rolling back.", username), e);
                    throw new RuntimeException("Creating username failed", e);
                }
                finally {
                    usernameTopicRef.set(usernameTopic);
                }
            }
        });
        return (Topic)usernameTopicRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Topic lookupOrCreateUsernameTopic(String username) {
        Topic usernameTopic = this.acs.getUsernameTopic(username);
        if (usernameTopic != null) {
            return usernameTopic;
        }
        DeepaMehtaTransaction tx = this.dm4.beginTx();
        try {
            usernameTopic = this.acs.createUsername(username);
            tx.success();
            Topic topic = usernameTopic;
            return topic;
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public Topic changePassword(Credentials cred) {
        if (!this.configuration.userCreationEnabled) {
            this.pluginLog.actionWarning("Cannot change password because user creation is disabled in plugin configuration!", null);
            return null;
        }
        Topic usernameTopic = this.acs.getUsernameTopic(cred.username);
        if (usernameTopic != null && this.ldap.changePassword(cred.username, cred.password)) {
            this.pluginLog.actionHint("Succesfully changed password for %s", cred.username);
            return usernameTopic;
        }
        return null;
    }

    @Override
    public boolean deleteUser(Credentials cred) {
        if (!this.configuration.userCreationEnabled) {
            this.pluginLog.actionWarning("Cannot delete user because user creation is disabled in plugin configuration!", null);
            return false;
        }
        Topic usernameTopic = this.acs.getUsernameTopic(cred.username);
        if (usernameTopic != null && this.ldap.deleteUser(cred.username, cred.password)) {
            this.pluginLog.actionHint("Succesfully deleted user %s in LDAP", cred.username);
            usernameTopic.delete();
            return true;
        }
        return false;
    }

    @Override
    public ProfileService getProfileService() {
        ProfileServiceImpl profileService = new ProfileServiceImpl(this.configuration, this.pluginLog);
        return new ProfileServiceAccessControl(this.acs, profileService);
    }
}

