/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.ldap.profile.repository.jndi;

import de.deepamehta.ldap.Configuration;
import de.deepamehta.ldap.PluginLog;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang.StringUtils;

class ContextManager {
    private final Configuration configuration;
    private final PluginLog pluginLog;

    ContextManager(Configuration configuration, PluginLog log) {
        this.configuration = configuration;
        this.pluginLog = log;
    }

    LdapContext openConnection(String username) {
        this.pluginLog.actionHint("Checking credentials for user %s", username);
        try {
            String url = this.configuration.getConnectionUrl();
            LdapContext ctx = this.connect(url, this.configuration.manager, this.configuration.password, false);
            String cn = this.lookupUserCn(ctx, username);
            if (cn == null) {
                this.pluginLog.actionHint("User %s not found in LDAP", username);
                return null;
            }
            return ctx;
        }
        catch (NamingException e) {
            throw new RuntimeException("Checking LDAP credentials lead to exception", e);
        }
    }

    private LdapContext connect(String serverUrl, String username, String password, boolean suppressNamingException) {
        this.pluginLog.actionHint("creating LDAP connection using URL %s and username %s", serverUrl, username);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.provider.url", serverUrl);
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.ldap.attributes.binary", "objectSID");
        if (this.configuration.loggingMode == Configuration.LoggingMode.DEBUG) {
            this.pluginLog.actionHint("Enabling detailed SSL logging", new Object[0]);
            System.setProperty("javax.net.debug", "all");
        }
        Control[] arr = new Control[]{};
        try {
            InitialLdapContext ctx = new InitialLdapContext(env, arr);
            this.pluginLog.actionHint("Initial context created", new Object[0]);
            if (this.configuration.protocol == Configuration.ProtocolType.STARTTLS) {
                this.pluginLog.actionHint("Attempting TLS negotiation (StartTLS protocol)", new Object[0]);
                StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                SSLSession session = tls.negotiate();
                this.pluginLog.actionHint("TLS negotiated successfully.", new Object[0]);
            }
            this.pluginLog.actionHint("Initial context usable", new Object[0]);
            return ctx;
        }
        catch (NamingException e) {
            if (suppressNamingException) {
                this.pluginLog.actionWarning("Attempting to connect to LDAP server lead to Exception", e);
                return null;
            }
            throw new RuntimeException("Attempting to connect to LDAP server lead to Exception", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not establish TLS connection. Connecting failed.", e);
        }
    }

    String dnByUid(String uid) {
        return String.format("%s=%s,%s", this.configuration.userAttribute, uid, this.configuration.userBase);
    }

    private String lookupUserCn(LdapContext ctx, String uid) throws NamingException {
        String searchFilter = StringUtils.isEmpty((String)this.configuration.userFilter) ? String.format("(%s=%s)", this.configuration.userAttribute, uid) : String.format("(&(%s)(%s=%s))", this.configuration.userFilter, this.configuration.userAttribute, uid);
        this.pluginLog.actionHint("Complete filter expression for user lookup: %s", searchFilter);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search(this.configuration.userBase, searchFilter, searchControls);
        this.pluginLog.actionHint("Search base is: %s", this.configuration.userBase);
        if (results.hasMoreElements()) {
            this.pluginLog.actionHint("Lookup using search filter returned non-empty result", new Object[0]);
            SearchResult searchResult = (SearchResult)results.nextElement();
            if (results.hasMoreElements()) {
                throw new RuntimeException("Ambiguity in LDAP CN query: Matched multiple users for the accountName");
            }
            return searchResult.getNameInNamespace();
        }
        this.pluginLog.actionWarning("Lookup using search filter was empty.", null);
        return null;
    }

    void closeQuietly(LdapContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException ne) {
                this.pluginLog.actionWarning("Exception while closing connection", ne);
            }
        }
    }

    boolean store(StoreRunner runner) {
        try {
            runner.invoke();
        }
        catch (NamingException exception) {
            this.pluginLog.actionWarning("LDAP access failed.", exception);
            return false;
        }
        return true;
    }

    <T> T load(LoadRunner<T> runner) {
        try {
            return runner.invoke();
        }
        catch (NamingException exception) {
            this.pluginLog.actionWarning("LDAP access failed.", exception);
            return null;
        }
    }

    static interface LoadRunner<T> {
        public T invoke() throws NamingException;
    }

    static interface StoreRunner {
        public void invoke() throws NamingException;
    }
}

