/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.ldap;

import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.accesscontrol.AuthorizationMethod;
import systems.dmx.core.Topic;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.ldap.Configuration;
import systems.dmx.ldap.LDAP;
import systems.dmx.ldap.LDAP$;
import systems.dmx.ldap.PluginLog;
import systems.dmx.ldap.PluginLog$;
import systems.dmx.ldap.service.LDAPPluginService;

public class LDAPPlugin
extends PluginActivator
implements AuthorizationMethod,
LDAPPluginService {
    private static Logger logger = Logger.getLogger(LDAPPlugin.class.getName());
    @Inject
    private AccessControlService acs;
    private Configuration configuration;
    private PluginLog pluginLog;
    private LDAP ldap;

    public void serviceArrived(Object service) {
        ((AccessControlService)service).registerAuthorizationMethod("LDAP", (AuthorizationMethod)this);
    }

    public void serviceGone(Object service) {
        ((AccessControlService)service).unregisterAuthorizationMethod("LDAP");
    }

    public void init() {
        try {
            this.configuration = Configuration.createFromProperties();
            this.pluginLog = PluginLog$.newInstance(this.configuration.loggingMode);
        }
        catch (Exception e) {
            this.configuration = Configuration.createFallback();
            this.pluginLog = PluginLog$.newInstance(this.configuration.loggingMode);
            this.pluginLog.configurationError("Error parsing configuration", e);
            this.pluginLog.configurationHint("Configuration could not be parsed. Providing an emergency fallback configuration. LDAP logins will not work!", new Object[0]);
        }
        this.pluginLog.configurationHint("Plugin configuration:\n%s", this.configuration.summary());
        if (!this.configuration.check(this.pluginLog)) {
            this.pluginLog.configurationError("LDAP Plugin configuration is not correct. Please fix the issues mentioned in the log.", new Object[0]);
            this.ldap = LDAP$.newDummyInstance(this.pluginLog);
        } else {
            this.configuration.compile();
            this.ldap = LDAP$.newInstance(this.configuration, this.pluginLog);
        }
    }

    public Topic checkCredentials(Credentials cred) {
        if (this.ldap.checkCredentials(cred.username, cred.plaintextPassword)) {
            Topic username = this.lookupOrCreateUsernameTopic(cred.username);
            if (username != null) {
                this.pluginLog.actionHint("LDAP log-in successful for user %s", cred.username);
                return username;
            }
            this.pluginLog.actionError("Credentials in LDAP are OK but unable find or create username topic", null);
            return null;
        }
        this.pluginLog.actionError(String.format("Credential check for user %s failed.", cred.username), null);
        return null;
    }

    @Override
    public Topic createUser(Credentials cred) {
        if (!this.configuration.userCreationEnabled) {
            logger.warning("User creation is disabled in plugin configuration!");
            return null;
        }
        final AtomicReference usernameTopicRef = new AtomicReference();
        this.ldap.createUser(cred.username, cred.plaintextPassword, new LDAP.CompletableAction(){

            @Override
            public boolean run(String username) {
                Topic usernameTopic = null;
                try {
                    usernameTopic = LDAPPlugin.this.lookupOrCreateUsernameTopic(username);
                    boolean bl = usernameTopic != null;
                    return bl;
                }
                catch (Exception e) {
                    LDAPPlugin.this.pluginLog.actionError(String.format("Creating username %s failed but LDAP entry was already created. Rolling back.", username), e);
                    throw new RuntimeException("Creating username failed", e);
                }
                finally {
                    usernameTopicRef.set(usernameTopic);
                }
            }
        });
        return (Topic)usernameTopicRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Topic lookupOrCreateUsernameTopic(String username) {
        Topic usernameTopic = this.acs.getUsernameTopic(username);
        if (usernameTopic != null) {
            return usernameTopic;
        }
        DMXTransaction tx = this.dmx.beginTx();
        try {
            usernameTopic = this.acs.createUsername(username);
            tx.success();
            Topic topic = usernameTopic;
            return topic;
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public Topic changePassword(Credentials cred) {
        if (!this.configuration.userCreationEnabled) {
            this.pluginLog.actionWarning("Cannot change password because user creation is disabled in plugin configuration!", null);
            return null;
        }
        Topic usernameTopic = this.acs.getUsernameTopic(cred.username);
        if (usernameTopic != null && this.ldap.changePassword(cred.username, cred.plaintextPassword)) {
            this.pluginLog.actionHint("Succesfully changed password for %s", cred.username);
            return usernameTopic;
        }
        return null;
    }
}

