/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.ldap;

import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Collectors;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.crypto.password.LdapShaPasswordEncoder;
import systems.dmx.ldap.Configuration;
import systems.dmx.ldap.JndiLDAP$$Lambda$1;
import systems.dmx.ldap.JndiLDAP$$Lambda$2;
import systems.dmx.ldap.JndiLDAP$$Lambda$3;
import systems.dmx.ldap.LDAP;
import systems.dmx.ldap.PluginLog;

class JndiLDAP
implements LDAP {
    private final Configuration configuration;
    private final PluginLog pluginLog;
    private static final String ADMIN_USER = "admin";

    JndiLDAP(Configuration configuration, PluginLog log) {
        this.configuration = configuration;
        this.pluginLog = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createUser(String username, String password, LDAP.CompletableAction actionOnSuccess) {
        LdapContext ctx = null;
        try {
            ctx = this.connect();
            String encodedPassword = new LdapShaPasswordEncoder().encode((CharSequence)password);
            boolean bl = this.createUserImpl(ctx, username, encodedPassword) && actionOnSuccess.run(username);
            return bl;
        }
        finally {
            this.closeQuietly(ctx);
        }
    }

    private boolean createUserImpl(LdapContext ctx, String userName, String password) {
        String entryDN = String.format("%s=%s,%s", this.configuration.userAttribute, userName, this.configuration.userBase);
        BasicAttribute cn = new BasicAttribute("cn", userName);
        BasicAttribute sn = new BasicAttribute("sn", "deepamehta-ldap");
        BasicAttribute userPassword = new BasicAttribute("userPassword", password);
        BasicAttribute oc = new BasicAttribute("objectClass");
        oc.add("top");
        oc.add("person");
        oc.add("organizationalPerson");
        oc.add("inetOrgPerson");
        BasicAttributes entry = new BasicAttributes();
        entry.put(oc);
        entry.put(cn);
        entry.put(sn);
        entry.put(userPassword);
        try {
            ctx.createSubcontext(entryDN, (Attributes)entry);
        }
        catch (NamingException ne) {
            this.pluginLog.actionError("Unable to create user subcontext", ne);
            return false;
        }
        if (StringUtils.isNotEmpty((String)this.configuration.userMemberGroup)) {
            ModificationItem mi = new ModificationItem(1, new BasicAttribute("member", entryDN));
            try {
                ctx.modifyAttributes(this.configuration.userMemberGroup, new ModificationItem[]{mi});
            }
            catch (NamingException ne) {
                this.pluginLog.actionError("Membership attribute addition failed - rollback!", ne);
                try {
                    ctx.destroySubcontext(entryDN);
                }
                catch (NamingException ne2) {
                    this.pluginLog.actionError("Unable to rollback context creation!", ne2);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkCredentials(String username, String password) {
        String cn;
        String url;
        LdapContext ctx2;
        LdapContext ctx;
        block6: {
            this.pluginLog.actionHint("Checking credentials for user %s", username);
            ctx = null;
            ctx2 = null;
            url = this.configuration.getConnectionUrl();
            ctx = this.connect(url, this.configuration.manager, this.configuration.password, false);
            cn = this.lookupUserCn(ctx, username);
            if (cn != null) break block6;
            this.pluginLog.actionHint("User %s not found in LDAP", username);
            boolean bl = false;
            this.closeQuietly(ctx);
            this.closeQuietly(ctx2);
            return bl;
        }
        try {
            ctx2 = this.connect(url, cn, password, true);
            if (ctx == null) {
                this.pluginLog.actionHint("Provided credentials for user %s were wrong", username);
            }
            boolean bl = ctx2 != null;
            this.closeQuietly(ctx);
            this.closeQuietly(ctx2);
            return bl;
        }
        catch (NamingException e) {
            try {
                throw new RuntimeException("Checking LDAP credentials lead to exception", e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(ctx);
                this.closeQuietly(ctx2);
                throw throwable;
            }
        }
    }

    private String lookupUserCn(LdapContext ctx, String uid) throws NamingException {
        String searchFilter = StringUtils.isEmpty((String)this.configuration.userFilter) ? String.format("(%s=%s)", this.configuration.userAttribute, uid) : String.format("(&(%s)(%s=%s))", this.configuration.userFilter, this.configuration.userAttribute, uid);
        this.pluginLog.actionHint("Complete filter expression for user lookup: %s", searchFilter);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search(this.configuration.userBase, searchFilter, searchControls);
        this.pluginLog.actionHint("Search base is: %s", this.configuration.userBase);
        if (results.hasMoreElements()) {
            this.pluginLog.actionHint("Lookup using search filter returned non-empty result", new Object[0]);
            SearchResult searchResult = (SearchResult)results.nextElement();
            if (results.hasMoreElements()) {
                throw new RuntimeException("Ambiguity in LDAP CN query: Matched multiple users for the accountName");
            }
            return searchResult.getNameInNamespace();
        }
        this.pluginLog.actionWarning("Lookup using search filter was empty.", new Object[0]);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changePassword(String username, String password) {
        this.pluginLog.actionHint("Changing password for user %s", username);
        LdapContext ctx = null;
        try {
            ctx = this.connect();
            String encodedPassword = new LdapShaPasswordEncoder().encode((CharSequence)password);
            boolean bl = this.changePasswordImpl(ctx, username, encodedPassword);
            return bl;
        }
        finally {
            this.closeQuietly(ctx);
        }
    }

    boolean changePasswordImpl(LdapContext ctx, String userName, String password) {
        String entryDN = this.userNameToEntryDn(userName);
        ModificationItem mi = new ModificationItem(2, new BasicAttribute("userPassword", password));
        try {
            ctx.modifyAttributes(entryDN, new ModificationItem[]{mi});
        }
        catch (NamingException ne) {
            this.pluginLog.actionWarning("Attempt to modify userPassword attribute lead to exception", ne);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteUser(String user) {
        LdapContext ctx = null;
        try {
            ctx = this.connect();
            ctx.destroySubcontext(this.userNameToEntryDn(user));
            boolean bl = true;
            return bl;
        }
        catch (NamingException e) {
            this.pluginLog.actionError(String.format("Unable to delete user from LDAP %s", user), e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeQuietly(ctx);
        }
    }

    private String userNameToEntryDn(String userName) {
        return String.format("%s=%s,%s", this.configuration.userAttribute, userName, this.configuration.userBase);
    }

    private LdapContext connect() {
        return this.connect(this.configuration.getConnectionUrl(), this.configuration.manager, this.configuration.password, false);
    }

    private LdapContext connect(String serverUrl, String username, String password, boolean suppressNamingException) {
        this.pluginLog.actionHint("creating LDAP connection using URL %s and username %s", serverUrl, username);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.provider.url", serverUrl);
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.ldap.attributes.binary", "objectSID");
        if (this.configuration.loggingMode == Configuration.LoggingMode.DEBUG) {
            this.pluginLog.actionHint("Enabling detailed SSL logging", new Object[0]);
            System.setProperty("javax.net.debug", "all");
        }
        Control[] arr = new Control[]{};
        try {
            InitialLdapContext ctx = new InitialLdapContext(env, arr);
            this.pluginLog.actionHint("Initial context created", new Object[0]);
            if (this.configuration.protocol == Configuration.ProtocolType.STARTTLS) {
                this.pluginLog.actionHint("Attempting TLS negotiation (StartTLS protocol)", new Object[0]);
                StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                SSLSession session = tls.negotiate();
                this.pluginLog.actionHint("TLS negotiated successfully.", new Object[0]);
            }
            this.pluginLog.actionHint("Initial context usable", new Object[0]);
            return ctx;
        }
        catch (NamingException e) {
            if (suppressNamingException) {
                this.pluginLog.actionWarning("Attempting to connect to LDAP server lead to Exception", e);
                return null;
            }
            throw new RuntimeException("Attempting to connect to LDAP server lead to Exception", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not establish TLS connection. Connecting failed.", e);
        }
    }

    private void closeQuietly(LdapContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException ne) {
                this.pluginLog.actionWarning("Exception while closing connection", ne);
            }
        }
    }

    private String groupDn(String groupName) {
        return String.format("cn=%s,%s", groupName, this.configuration.groupBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addMember(String group, String user) {
        String groupDn = this.groupDn(group);
        this.pluginLog.actionHint("Adding user %s to group %s", user, groupDn);
        LdapContext ctx = null;
        try {
            ctx = this.connect();
            boolean bl = this.addMemberImpl(ctx, groupDn, user);
            return bl;
        }
        finally {
            this.closeQuietly(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createGroup(String group, String user, List<String> members) {
        LdapContext ctx = null;
        try {
            ctx = this.connect();
            String groupDn = this.groupDn(group);
            String firstMemberDn = this.resolveUserDn(ctx, user);
            LdapContext finalCtx = ctx;
            List<String> otherMemberDns = members.stream().map(JndiLDAP$$Lambda$1.lambdaFactory$(this, finalCtx)).filter(JndiLDAP$$Lambda$2.lambdaFactory$()).collect(Collectors.toList());
            boolean bl = this.createGroupImpl(ctx, groupDn, firstMemberDn, otherMemberDns);
            return bl;
        }
        finally {
            this.closeQuietly(ctx);
        }
    }

    private boolean createGroupImpl(LdapContext ctx, String groupDn, String firstMemberDn, List<String> otherMemberDns) {
        BasicAttribute member;
        this.pluginLog.actionHint("Creating group %s with first member %s and %s other members", groupDn, firstMemberDn, otherMemberDns.size());
        BasicAttribute basicAttribute = member = new BasicAttribute("member", firstMemberDn);
        basicAttribute.getClass();
        otherMemberDns.forEach(JndiLDAP$$Lambda$3.lambdaFactory$(basicAttribute));
        BasicAttribute oc = new BasicAttribute("objectClass");
        oc.add("top");
        oc.add("groupOfNames");
        BasicAttributes entry = new BasicAttributes();
        entry.put(oc);
        entry.put(member);
        try {
            ctx.createSubcontext(groupDn, (Attributes)entry);
        }
        catch (NamingException ne) {
            this.pluginLog.actionError("Unable to create group subcontext", ne);
            return false;
        }
        return true;
    }

    private boolean addMemberImpl(LdapContext ctx, String groupDn, String user) {
        String userEntryDn = this.resolveUserDn(ctx, user);
        if (userEntryDn == null) {
            return false;
        }
        try {
            ctx.lookup(groupDn);
        }
        catch (NamingException ne) {
            this.pluginLog.actionHint("Group %s does not exist. Attempting to create it.", groupDn);
            return this.createGroupImpl(ctx, groupDn, userEntryDn, Collections.<String>emptyList());
        }
        ModificationItem mi = new ModificationItem(1, new BasicAttribute("member", userEntryDn));
        try {
            ctx.modifyAttributes(groupDn, new ModificationItem[]{mi});
        }
        catch (NamingException ne) {
            this.pluginLog.actionWarning("Attempt to modify member attribute lead to exception", ne);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteGroup(String group) {
        String groupDn = this.groupDn(group);
        LdapContext ctx = null;
        try {
            this.pluginLog.actionHint("Trying to delete group %s", groupDn);
            ctx = this.connect();
            ctx.destroySubcontext(groupDn);
            boolean bl = true;
            this.closeQuietly(ctx);
            return bl;
        }
        catch (NamingException ne) {
            this.pluginLog.actionWarning("Attempt to delete group lead to exception", ne);
        }
        finally {
            this.closeQuietly(ctx);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeMember(String group, String user) {
        String groupDn = this.groupDn(group);
        this.pluginLog.actionHint("Removing user %s from group %s", user, groupDn);
        LdapContext ctx = null;
        try {
            ctx = this.connect();
            String userDn = this.resolveUserDn(ctx, user);
            if (userDn == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.removeMemberImpl(ctx, groupDn, userDn);
            return bl;
        }
        finally {
            this.closeQuietly(ctx);
        }
    }

    private boolean maybeDeleteGroup(LdapContext ctx, DirContext groupContext, String groupDn, String userEntryDn) {
        try {
            Attribute a = groupContext.getAttributes("").get("member");
            if (a.size() == 1 && userEntryDn.equals(a.get(0))) {
                this.pluginLog.actionHint("Group %s is now empty. Attempting to delete.", groupDn);
                ctx.destroySubcontext(groupDn);
                return true;
            }
        }
        catch (NamingException ne) {
            this.pluginLog.actionHint("Unable to check membership or delete the group %s", groupDn);
        }
        return false;
    }

    private String resolveUserDn(LdapContext ctx, String userName) {
        String userDn = this.userNameToEntryDn(userName);
        try {
            ctx.lookup(userDn);
            return userDn;
        }
        catch (NamingException ne) {
            if (userName.equals(ADMIN_USER)) {
                return this.configuration.manager;
            }
            this.pluginLog.actionWarning("Unable to find regular user %s in LDAP. Ignoring", userName);
            return null;
        }
    }

    private boolean removeMemberImpl(LdapContext ctx, String groupDn, String userEntryDn) {
        DirContext groupContext;
        try {
            groupContext = (DirContext)ctx.lookup(groupDn);
        }
        catch (NamingException ne) {
            this.pluginLog.actionWarning("Unable to look up group lead to exception", ne);
            return false;
        }
        if (this.maybeDeleteGroup(ctx, groupContext, groupDn, userEntryDn)) {
            return true;
        }
        ModificationItem mi = new ModificationItem(3, new BasicAttribute("member", userEntryDn));
        try {
            ctx.modifyAttributes(groupDn, new ModificationItem[]{mi});
        }
        catch (NamingException ne) {
            this.pluginLog.actionWarning("Attempt to modify member attribute lead to exception", ne);
            return false;
        }
        return true;
    }

    static /* synthetic */ String lambda$createGroup$0(JndiLDAP this_, LdapContext finalCtx, String it) {
        return this_.resolveUserDn(finalCtx, it);
    }
}

