/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.ldap;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import systems.dmx.ldap.PluginLog;

public class Configuration {
    ProtocolType protocol;
    String server;
    String port;
    ImplementationType implementation;
    LoggingMode loggingMode;
    boolean userCreationEnabled;
    String manager;
    String password;
    String userBase;
    String userAttribute;
    String userFilter;
    String userMemberGroup;
    String groupBase;
    private String connectionUrl;

    String getConnectionUrl() {
        return this.connectionUrl;
    }

    private Configuration() {
    }

    static Configuration createFromProperties() {
        Configuration c = new Configuration();
        c.server = System.getProperty("dmx.ldap.server", "127.0.0.1");
        c.protocol = ProtocolType.valueOf(System.getProperty("dmx.ldap.protocol", "ldap").toUpperCase());
        c.port = System.getProperty("dmx.ldap.port", "389");
        c.loggingMode = LoggingMode.valueOf(System.getProperty("dmx.ldap.logging", "info").toUpperCase());
        c.userCreationEnabled = System.getProperty("dmx.ldap.user_creation.enabled", "false").equals("true");
        c.implementation = ImplementationType.JNDI;
        c.manager = System.getProperty("dmx.ldap.manager", "");
        c.password = System.getProperty("dmx.ldap.password", "");
        c.userBase = System.getProperty("dmx.ldap.user_base", "");
        c.userAttribute = System.getProperty("dmx.ldap.user_attribute", "");
        c.userFilter = System.getProperty("dmx.ldap.user_filter", "");
        c.userMemberGroup = System.getProperty("dmx.ldap.user_member_group", "");
        c.groupBase = System.getProperty("dmx.ldap.group_base", "");
        return c;
    }

    static Configuration createFallback() {
        Configuration c = new Configuration();
        c.server = "127.0.0.1";
        c.protocol = ProtocolType.LDAP;
        c.port = "389";
        c.loggingMode = LoggingMode.DEBUG;
        c.implementation = ImplementationType.JNDI;
        c.manager = "";
        c.password = "";
        c.userBase = "";
        c.userAttribute = "";
        c.userFilter = "";
        c.userMemberGroup = "";
        c.groupBase = "";
        return c;
    }

    boolean check(PluginLog log) {
        int errorCount;
        block26: {
            errorCount = 0;
            log.configurationHint("Logging is set up for %s environment.", this.loggingMode.toString().toLowerCase());
            if (StringUtils.isEmpty((String)this.manager)) {
                log.configurationError("No manager account provided. Check property 'dmx.ldap.manager'!", new Object[0]);
                ++errorCount;
            }
            if (StringUtils.isEmpty((String)this.password)) {
                log.configurationWarning("No manager password provided. Check property 'dmx.ldap.password'!", new Object[0]);
            }
            if (StringUtils.isEmpty((String)this.userBase)) {
                log.configurationError("No user base provided. Check property 'dmx.ldap.user_base'!", new Object[0]);
                ++errorCount;
            }
            if (StringUtils.isEmpty((String)this.userAttribute)) {
                log.configurationHint("User attribute not set. Defaults to 'uid'. Check property 'dmx.ldap.user_attribute' to customize!", new Object[0]);
                this.userAttribute = "uid";
            }
            if (StringUtils.isEmpty((String)this.userFilter)) {
                log.configurationHint("No filter expression provided. Defaulting to mere existance check. Check property 'dmx.ldap.user_filter' to customize!", new Object[0]);
            }
            if (StringUtils.isEmpty((String)this.groupBase)) {
                log.configurationHint("No group base defined. LDAP Group handling will not work. Check property 'dmx.ldap.group_base'!", new Object[0]);
            }
            if (this.userCreationEnabled) {
                log.configurationHint("User creation enabled. LDAP entry creation and attribute modification may occur.", new Object[0]);
                if (StringUtils.isEmpty((String)this.userMemberGroup)) {
                    log.configurationHint("No member group provided. Automatically adding inetOrgPerson entries to groups is disabled. Check property 'dmx.ldap.user_member_group' to customize!", new Object[0]);
                    if (StringUtils.isNotEmpty((String)this.userFilter)) {
                        log.configurationWarning("Custom filter expression provided but no member group for new users. This might lead to new users not being able to log-in. Check property 'dmx.ldap.user_member_group'!", new Object[0]);
                    }
                } else {
                    log.configurationHint("Automatically adding inetOrgPerson entries to groups is enabled.", new Object[0]);
                    if (StringUtils.isEmpty((String)this.userFilter)) {
                        log.configurationWarning("Member group defined but no filter expression. As such group membership is not checked during log-in. Check property 'dmx.ldap.user_filter'!", new Object[0]);
                    }
                }
            } else {
                log.configurationHint("User creation disabled. All LDAP accesses are read-only.", new Object[0]);
            }
            String trustStore = System.getProperty("javax.net.ssl.trustStore", "");
            String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword", "");
            if (this.protocol != ProtocolType.LDAP) {
                if (StringUtils.isEmpty((String)trustStore)) {
                    log.configurationWarning("Secure connection requested but no custom SSL/TLS trust store defined. Connection negotiation may fail. Check system property 'javax.net.ssl.trustStore' and 'javax.net.ssl.trustStorePassword'!", new Object[0]);
                } else {
                    if (StringUtils.isEmpty((String)trustStorePassword)) {
                        log.configurationWarning("Custom keystore was configured but password is empty. Opening the keystore and accessing its content may fail. Check system property 'javax.net.ssl.trustStorePassword'!", new Object[0]);
                    }
                    try {
                        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                        keyStore.load(new FileInputStream(trustStore), trustStorePassword.toCharArray());
                        log.configurationHint("Configured trust store %s is usable with provided password.", trustStore);
                        int count = 0;
                        Enumeration<String> aliases = keyStore.aliases();
                        while (aliases.hasMoreElements()) {
                            ++count;
                            aliases.nextElement();
                        }
                        if (count == 0) {
                            log.configurationError("Configured trust store does not contain any aliases. Please check the file.", new Object[0]);
                            break block26;
                        }
                        log.configurationHint("Configured trust store contains %s aliases. It appears valid for SSL/TLS connections", count);
                    }
                    catch (KeyStoreException e) {
                        log.configurationError("Unable to initialize default trust store. Expecting \"Java Keystore\" format: %s", e.getLocalizedMessage());
                    }
                    catch (NoSuchAlgorithmException e) {
                        log.configurationError("Unable to load trust store. Check whether it is in the default \"Java Keystore\" format: %s", e.getLocalizedMessage());
                    }
                    catch (CertificateException e) {
                        log.configurationError("Unable to load trust store. Issue with certificates: %s", e.getLocalizedMessage());
                    }
                    catch (FileNotFoundException e) {
                        log.configurationError("Trust store configured to %s but file is not accessible: %s. Check system property 'javax.net.ssl.trustStore' and 'javax.net.ssl.trustStorePassword'!", trustStore, e.getLocalizedMessage());
                    }
                    catch (IOException e) {
                        log.configurationError("Trust store configured to %s but reading the file failed: %s. Check system property 'javax.net.ssl.trustStore' and 'javax.net.ssl.trustStorePassword'!", trustStore, e.getLocalizedMessage());
                    }
                }
            } else if (StringUtils.isNotEmpty((String)trustStore)) {
                log.configurationWarning("A trust store located at %s was specified but using a non-SSL/TLS protocol. Check configuration.", trustStore);
            }
        }
        return errorCount == 0;
    }

    void compile() {
        if (StringUtils.isEmpty((String)this.port)) {
            this.port = this.protocol == ProtocolType.LDAP ? "636" : "389";
        }
        this.connectionUrl = String.format("ldap%s://%s:%s", this.protocol == ProtocolType.LDAPS ? "s" : "", this.server, this.port);
    }

    String summary() {
        String trustStore = System.getProperty("javax.net.ssl.trustStore", "");
        String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword", "");
        String trustStoreSummary = this.protocol != ProtocolType.LDAP || StringUtils.isNotEmpty((String)trustStore) ? String.format("javax.net.ssl.trustStore=%s\njavax.net.ssl.trustStorePassword=%s", trustStore, StringUtils.isEmpty((String)trustStorePassword) ? "" : "***") : "";
        String maskedPassword = StringUtils.isEmpty((String)this.password) ? "" : "***";
        return String.format("dmx.ldap.protocol=%s\ndmx.ldap.server=%s\ndmx.ldap.port=%s\ndmx.ldap.implementation=%s\ndmx.ldap.logging=%s\ndmx.ldap.user_creation.enabled=%s\ndmx.ldap.manager=%s\ndmx.ldap.password=%s\ndmx.ldap.user_base=%s\ndmx.ldap.user_attribute=%s\ndmx.ldap.user_acceptance_filter=%s\ndmx.ldap.user_member_group=%s\ndmx.ldap.group_base=%s\n%s", new Object[]{this.protocol, this.server, this.port, this.implementation, this.loggingMode, this.userCreationEnabled, this.manager, maskedPassword, this.userBase, this.userAttribute, this.userFilter, this.userMemberGroup, this.groupBase, trustStoreSummary});
    }

    public static enum LoggingMode {
        INFO,
        DEBUG;

    }

    public static enum ImplementationType {
        JNDI,
        APACHE;

    }

    public static enum ProtocolType {
        LDAP,
        LDAPS,
        STARTTLS;

    }
}

