/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.ldap;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import systems.dmx.ldap.PluginLog;

public class TroubleShootingLog
implements PluginLog {
    private Logger logger = Logger.getLogger(TroubleShootingLog.class.getName());

    @Override
    public void configurationDebug(String msg, Object ... args) {
        this.logger.log(Level.FINE, String.format(msg, args));
    }

    @Override
    public void configurationHint(String msg, Object ... args) {
        this.logger.log(Level.INFO, String.format(msg, args));
    }

    @Override
    public void configurationWarning(String msg, Object ... args) {
        this.logger.log(Level.WARNING, String.format(msg, args));
    }

    @Override
    public void configurationError(String msg, Object ... args) {
        this.logger.log(Level.SEVERE, String.format(msg, args));
    }

    private static String prepareMessage(String message, Throwable throwable) {
        StringBuffer sb = new StringBuffer();
        sb.append(message);
        if (throwable != null) {
            sb.append(": ");
            TroubleShootingLog.appendMessage(sb, throwable);
        }
        return sb.toString();
    }

    private static void appendMessage(StringBuffer sb, Throwable throwable) {
        Throwable parent;
        sb.append(throwable.getLocalizedMessage());
        if (throwable instanceof NamingException) {
            sb.append(": ");
            sb.append(((NamingException)throwable).getExplanation());
        }
        if ((parent = throwable.getCause()) != null) {
            sb.append(" caused by ");
            TroubleShootingLog.appendMessage(sb, parent);
        }
    }

    @Override
    public void actionHint(String msg, Object ... args) {
        this.logger.log(Level.INFO, String.format(msg, args));
    }

    @Override
    public void actionWarning(String message, Object ... args) {
        this.logger.log(Level.WARNING, String.format(message, args));
    }

    @Override
    public void actionWarning(String message, Throwable throwable) {
        this.logger.log(Level.WARNING, TroubleShootingLog.prepareMessage(message, throwable));
    }

    @Override
    public void actionError(String message, Throwable throwable) {
        this.logger.log(Level.SEVERE, TroubleShootingLog.prepareMessage(message, throwable));
    }
}

