/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.ldap;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSession;
import systems.dmx.ldap.Configuration;
import systems.dmx.ldap.LDAP;
import systems.dmx.ldap.PluginLog;

class NonManagerJndiLDAP
implements LDAP {
    private final Configuration configuration;
    private final PluginLog pluginLog;

    NonManagerJndiLDAP(Configuration configuration, PluginLog log) {
        this.configuration = configuration;
        this.pluginLog = log;
    }

    @Override
    public boolean createUser(String username, String password, LDAP.CompletableAction actionOnSuccess) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deleteUser(String user) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCredentials(String username, String password) {
        this.pluginLog.actionHint("Checking credentials for user %s", username);
        LdapContext ctx = null;
        try {
            String url = this.configuration.connectionUrl;
            String cn = this.userNameToEntryDn(username);
            ctx = this.connect(url, cn, password);
            if (ctx == null) {
                this.pluginLog.actionHint("Provided credentials for user %s were wrong", username);
            }
            boolean bl = ctx != null;
            this.closeQuietly(ctx);
            return bl;
        }
        catch (Throwable throwable) {
            this.closeQuietly(ctx);
            throw throwable;
        }
    }

    @Override
    public boolean changePassword(String username, String password) {
        throw new UnsupportedOperationException();
    }

    private String userNameToEntryDn(String userName) {
        return String.format("%s=%s,%s", this.configuration.userAttribute, userName, this.configuration.userBase);
    }

    private LdapContext connect(String serverUrl, String username, String password) {
        this.pluginLog.actionHint("creating LDAP connection using URL %s and username %s", serverUrl, username);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.provider.url", serverUrl);
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.ldap.attributes.binary", "objectSID");
        if (this.configuration.loggingMode == Configuration.LoggingMode.DEBUG) {
            this.pluginLog.actionHint("Enabling detailed SSL logging", new Object[0]);
            System.setProperty("javax.net.debug", "all");
        }
        Control[] arr = new Control[]{};
        try {
            InitialLdapContext ctx = new InitialLdapContext(env, arr);
            this.pluginLog.actionHint("Initial context created", new Object[0]);
            if (this.configuration.protocol == Configuration.ProtocolType.STARTTLS) {
                this.pluginLog.actionHint("Attempting TLS negotiation (StartTLS protocol)", new Object[0]);
                StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                SSLSession session = tls.negotiate();
                this.pluginLog.actionHint("TLS negotiated successfully.", new Object[0]);
            }
            this.pluginLog.actionHint("Initial context usable", new Object[0]);
            return ctx;
        }
        catch (NamingException e) {
            this.pluginLog.actionWarning("Attempting to connect to LDAP server lead to Exception", e);
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not establish TLS connection. Connecting failed.", e);
        }
    }

    private void closeQuietly(LdapContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException ne) {
                this.pluginLog.actionWarning("Exception while closing connection", ne);
            }
        }
    }

    @Override
    public boolean addMember(String group, String user) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean createGroup(String group, String user, List<String> members) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deleteGroup(String group) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeMember(String group, String user) {
        throw new UnsupportedOperationException();
    }
}

