/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.ldap.repository;

import java.util.List;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import systems.dmx.ldap.repository.JndiDatasource;
import systems.dmx.ldap.repository.JndiRepository;

class BindUserJndiRepository
implements JndiRepository {
    private final String manager;
    private final String password;
    private final JndiDatasource datasource;

    BindUserJndiRepository(String manager, String password, JndiDatasource datasource) {
        this.manager = manager;
        this.password = password;
        this.datasource = datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createUser(String username, String password, JndiRepository.CompletableAction actionOnSuccess) {
        LdapContext ctx = null;
        try {
            ctx = this.connect();
            this.datasource.createUser(ctx, username, password);
            boolean bl = actionOnSuccess.run(username);
            return bl;
        }
        catch (NamingException ne) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.datasource.closeQuietly(ctx);
        }
    }

    @Override
    public boolean checkCredentials(String username, String password) {
        return this.connectAndDo(ctx -> this.datasource.checkCredentialsWithLookup(ctx, username, password));
    }

    @Override
    public boolean changePassword(String username, String password) {
        return this.connectAndDo(ctx -> this.datasource.changePassword(ctx, username, password));
    }

    @Override
    public boolean deleteUser(String user) {
        return this.connectAndDo(ctx -> this.datasource.deleteUser(ctx, user));
    }

    private LdapContext connect() throws NamingException {
        return this.datasource.connect(this.manager, this.password);
    }

    @Override
    public boolean addMember(String group, String user) {
        return this.connectAndDo(ctx -> this.datasource.addMember(ctx, group, user));
    }

    @Override
    public boolean createGroup(String group, String user, List<String> members) {
        return this.connectAndDo(ctx -> this.datasource.createGroup(ctx, group, user, members));
    }

    @Override
    public boolean deleteGroup(String group) {
        return this.connectAndDo(ctx -> this.datasource.deleteGroup(ctx, group));
    }

    @Override
    public boolean removeMember(String group, String user) {
        return this.connectAndDo(ctx -> this.datasource.removeMember(ctx, group, user));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectAndDo(ContextRunnable r) {
        LdapContext ctx = null;
        try {
            ctx = this.connect();
            r.run(ctx);
            boolean bl = true;
            return bl;
        }
        catch (NamingException ne) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.datasource.closeQuietly(ctx);
        }
    }

    private static interface ContextRunnable {
        public void run(LdapContext var1) throws NamingException;
    }
}

