/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.ldap.repository;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.ldap.Configuration;
import systems.dmx.ldap.repository.BindUserJndiRepository;
import systems.dmx.ldap.repository.JndiDatasource;
import systems.dmx.ldap.repository.NonBindUserJndiRepository;

public interface JndiRepository {
    public boolean checkCredentials(String var1, String var2);

    public boolean createUser(String var1, String var2, CompletableAction var3);

    public boolean deleteUser(String var1);

    public boolean changePassword(String var1, String var2);

    public boolean createGroup(String var1, String var2, List<String> var3);

    public boolean deleteGroup(String var1);

    public boolean addMember(String var1, String var2);

    public boolean removeMember(String var1, String var2);

    public static JndiRepository newInstance(Configuration configuration) {
        JndiDatasource datasource = new JndiDatasource(configuration, "admin", configuration.manager);
        return configuration.useBindAccount ? new BindUserJndiRepository(configuration.manager, configuration.password, datasource) : new NonBindUserJndiRepository(datasource);
    }

    public static JndiRepository newDummyInstance() {
        final Logger logger = Logger.getLogger(JndiRepository.class.getName());
        return new JndiRepository(){

            private void logError() {
                logger.severe("LDAP plugin cannot fulfill request as it was not configured correctly.");
            }

            @Override
            public boolean checkCredentials(String user, String password) {
                this.logError();
                return false;
            }

            @Override
            public boolean createUser(String user, String password, CompletableAction actionOnSuccess) {
                this.logError();
                return false;
            }

            @Override
            public boolean deleteUser(String user) {
                this.logError();
                return false;
            }

            @Override
            public boolean changePassword(String user, String password) {
                this.logError();
                return false;
            }

            @Override
            public boolean addMember(String groupDn, String user) {
                this.logError();
                return false;
            }

            @Override
            public boolean removeMember(String groupDn, String user) {
                this.logError();
                return false;
            }

            @Override
            public boolean createGroup(String group, String user, List<String> members) {
                this.logError();
                return false;
            }

            @Override
            public boolean deleteGroup(String group) {
                this.logError();
                return false;
            }
        };
    }

    public static interface CompletableAction {
        default public boolean run(String userName) {
            return true;
        }
    }
}

