/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.linqa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.accesscontrol.event.PostLoginUser;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Cookies;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.PrivilegedAccess;
import systems.dmx.core.service.accesscontrol.SharingMode;
import systems.dmx.core.service.event.PostCreateAssoc;
import systems.dmx.core.service.event.PreDeleteAssoc;
import systems.dmx.core.service.event.PreSendTopic;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.core.util.IdList;
import systems.dmx.deepl.DeepLService;
import systems.dmx.deepl.Translation;
import systems.dmx.facets.FacetsService;
import systems.dmx.linqa.EmailDigests;
import systems.dmx.linqa.LinqaService;
import systems.dmx.linqa.Messenger;
import systems.dmx.sendmail.SendmailService;
import systems.dmx.signup.SignupService;
import systems.dmx.timestamps.TimestampsService;
import systems.dmx.topicmaps.TopicmapCustomizer;
import systems.dmx.topicmaps.TopicmapsService;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/linqa")
@Produces(value={"application/json"})
public class LinqaPlugin
extends PluginActivator
implements LinqaService,
TopicmapCustomizer,
PostCreateAssoc,
PreDeleteAssoc,
PreSendTopic,
PostLoginUser {
    @Inject
    private DeepLService deepls;
    @Inject
    private TimestampsService timestamps;
    @Inject
    private TopicmapsService tms;
    @Inject
    private WorkspacesService ws;
    @Inject
    private AccessControlService acs;
    @Inject
    private FacetsService facets;
    @Inject
    private SignupService signup;
    @Inject
    private SendmailService sendmail;
    private Topic zwPluginTopic;
    private Topic teamWorkspace;
    private Messenger me;
    private Random random = new Random();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public void init() {
        this.zwPluginTopic = this.dmx.getTopicByUri("systems.dmx.linqa");
        this.teamWorkspace = this.dmx.getTopicByUri("linqa.team");
        this.tms.registerTopicmapCustomizer((TopicmapCustomizer)this);
        this.me = new Messenger(this.dmx.getWebSocketService());
        new EmailDigests(this.dmx, this.acs, this.ws, this.timestamps, this.sendmail, this.teamWorkspace).startTimedTask();
    }

    public void shutdown() {
        this.tms.unregisterTopicmapCustomizer((TopicmapCustomizer)this);
    }

    public void postCreateAssoc(Assoc assoc) {
        this.processTeamMembership(assoc, username -> {
            this.logger.info("### Inviting user \"" + username + "\" to \"System\" workspace");
            this.acs.createMembership(username, this.dmx.getPrivilegedAccess().getSystemWorkspaceId());
            List<RelatedTopic> workspaces = this.getAllZWWorkspaces();
            this.logger.info("### Inviting user \"" + username + "\" to " + workspaces.size() + " ZW workspaces");
            this.acs.bulkUpdateMemberships(username, new IdList(workspaces), null);
        });
    }

    public void preDeleteAssoc(Assoc assoc) {
        this.processTeamMembership(assoc, username -> {
            this.logger.info("### Removing \"System\" membership from user \"" + username + "\"");
            this.acs.getMembership(username, this.dmx.getPrivilegedAccess().getSystemWorkspaceId()).delete();
        });
    }

    public void preSendTopic(Topic topic) {
        RelatedTopic editor;
        Assoc assoc;
        String typeUri = topic.getTypeUri();
        if (typeUri.equals("linqa.comment")) {
            RelatedTopic refTextblock;
            this.acs.enrichWithUserInfo((DMXObject)topic);
            RelatedTopic refComment = topic.getChildTopics().getTopicOrNull("linqa.comment");
            if (refComment != null) {
                this.acs.enrichWithUserInfo((DMXObject)refComment);
            }
            if ((refTextblock = topic.getChildTopics().getTopicOrNull("linqa.textblock")) != null) {
                this.enrichWithColor((Topic)refTextblock);
            }
        } else if (typeUri.equals("dmx.workspaces.workspace")) {
            this.acs.enrichWithOwnerInfo(topic);
        } else if (typeUri.equals("dmx.accesscontrol.username")) {
            String username = topic.getSimpleValue().toString();
            ChildTopicsModel topics = topic.getChildTopics().getModel();
            String displayName = this.signup.getDisplayName(username);
            if (displayName != null) {
                topics.set("dmx.signup.display_name", (Object)displayName);
            }
            topics.set("linqa.show_email_address", (Object)this.getShowEmailAddress(username));
            this.enrichWithUserActive(topic);
        }
        if (topic instanceof RelatedTopic && (assoc = ((RelatedTopic)topic).getRelatingAssoc()).getTypeUri().equals("dmx.accesscontrol.membership") && (editor = this.facets.getFacet((DMXObject)assoc, "linqa.editor_facet")) != null) {
            String[] a = editor.getSimpleValue().toString().split(":");
            boolean isEditor = Boolean.parseBoolean(a[1]);
            assoc.getChildTopics().getModel().set("linqa.editor", (Object)isEditor);
        }
    }

    public void postLoginUser(String username) {
        DMXTransaction tx = this.dmx.beginTx();
        try {
            this.acs.getUsernameTopic(username).setProperty("linqa.user_active", (Object)true, false);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public void customizeTopic(RelatedTopic topic, ViewProps viewProps) {
        Assoc assoc = topic.getRelatingAssoc();
        String typeUri = topic.getTypeUri();
        if ((typeUri.equals("linqa.document") || typeUri.equals("linqa.note") || typeUri.equals("linqa.textblock") || typeUri.equals("linqa.label") || typeUri.equals("linqa.arrow")) && assoc.hasProperty("linqa.angle")) {
            viewProps.set("linqa.angle", assoc.getProperty("linqa.angle"));
        }
        if (typeUri.equals("linqa.note") || typeUri.equals("linqa.textblock")) {
            if (assoc.hasProperty("linqa.color")) {
                topic.getChildTopics().getModel().set("linqa.color", assoc.getProperty("linqa.color"));
            }
        } else if (typeUri.equals("linqa.viewport")) {
            viewProps.set("dmx.topicmaps.zoom", assoc.getProperty("dmx.topicmaps.zoom"));
        }
    }

    @Override
    @GET
    @Path(value="/workspaces")
    public List<RelatedTopic> getZWWorkspaces() {
        try {
            Topic username = this.acs.getUsernameTopic();
            if (username != null) {
                return this.getZWWorkspaces(username);
            }
            return new ArrayList<RelatedTopic>();
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving the user's ZW workspaces failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/discussion")
    public List<Topic> getDiscussion() {
        try {
            return DMXUtils.loadChildTopics((List)this.ws.getAssignedTopics(this.workspaceId(), "linqa.comment"));
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving the discussion for workspace " + this.workspaceId() + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/users")
    public List<Topic> getAllUsers() {
        try {
            return this.dmx.getTopicsByType("dmx.accesscontrol.username");
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving all ZW users failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/document")
    @Transactional
    public Topic createDocument(String docName, @QueryParam(value="fileId") long fileId) {
        try {
            TopicModel document = this.createBilingualTopicModel("linqa.document", docName, "linqa.document_name");
            String lang = document.getChildTopics().getString("linqa.language#linqa.original_language");
            document.getChildTopics().setRef("dmx.files.file#linqa." + lang, fileId);
            return this.dmx.createTopic(document);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating document failed, docName=\"" + docName + "\", fileId=" + fileId, e);
        }
    }

    @Override
    @POST
    @Path(value="/note")
    @Transactional
    public Topic createNote(String note) {
        try {
            return this.dmx.createTopic(this.createBilingualTopicModel("linqa.note", note));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating note failed, note=\"" + note + "\"", e);
        }
    }

    @Override
    @POST
    @Path(value="/textblock")
    @Transactional
    public Topic createTextblock(String textblock) {
        try {
            return this.dmx.createTopic(this.createBilingualTopicModel("linqa.textblock", textblock));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating textblock failed, textblock=\"" + textblock + "\"", e);
        }
    }

    @Override
    @POST
    @Path(value="/label")
    @Transactional
    public Topic createLabel(String label) {
        try {
            return this.dmx.createTopic(this.createBilingualTopicModel("linqa.label", label));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating label failed, label=\"" + label + "\"", e);
        }
    }

    @Override
    @POST
    @Path(value="/comment")
    @Transactional
    public Topic createComment(String comment, @QueryParam(value="refTopicIds") IdList refTopicIds, @QueryParam(value="fileTopicIds") IdList fileTopicIds) {
        try {
            return this._createComment(this.createBilingualTopicModel("linqa.comment", comment), refTopicIds, fileTopicIds);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating comment failed, refTopicIds=" + refTopicIds + ", fileTopicIds=" + fileTopicIds, e);
        }
    }

    @Override
    @POST
    @Path(value="/comment/monolingual")
    @Transactional
    public Topic createMonolingualComment(String comment, @QueryParam(value="refTopicIds") IdList refTopicIds, @QueryParam(value="fileTopicIds") IdList fileTopicIds) {
        try {
            return this._createComment(this.mf.newTopicModel("linqa.comment", this.mf.newChildTopicsModel().set("linqa.comment.de", (Object)comment)), refTopicIds, fileTopicIds);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating monolingual comment failed, refTopicIds=" + refTopicIds + ", fileTopicIds=" + fileTopicIds, e);
        }
    }

    @Override
    public Topic createViewport(long workspaceId) {
        List topicmaps = this.ws.getAssignedTopics(workspaceId, "dmx.topicmaps.topicmap");
        if (topicmaps.size() != 1) {
            throw new RuntimeException("Workspace " + workspaceId + " has " + topicmaps.size() + " topicmaps (expected is 1)");
        }
        long topicmapId = ((Topic)topicmaps.get(0)).getId();
        Topic viewport = this.dmx.createTopic(this.mf.newTopicModel("linqa.viewport", new SimpleValue("Viewport " + this.random.nextLong())));
        ViewProps viewProps = this.mf.newViewProps(0, 0, true, false);
        viewProps.set("dmx.topicmaps.zoom", (Object)1);
        this.tms.addTopicToTopicmap(topicmapId, viewport.getId(), viewProps);
        return viewport;
    }

    @Override
    @POST
    @Path(value="/translate")
    public Translation translate(String text, @QueryParam(value="targetLang") String targetLang) {
        try {
            if (targetLang == null) {
                Translation translation = (Translation)this.deepls.translate(text, "en").get(0);
                String origLang = translation.detectedSourceLang;
                targetLang = this.targetLang(origLang);
            }
            return (Translation)this.deepls.translate(text, targetLang).get(0);
        }
        catch (Exception e) {
            throw new RuntimeException("Translation failed, text=\"" + text + "\", targetLang=" + targetLang, e);
        }
    }

    @Override
    @PUT
    @Path(value="/user_profile")
    @Transactional
    public void updateUserProfile(@QueryParam(value="displayName") String displayName, @QueryParam(value="showEmailAddress") boolean showEmailAddress) {
        String username = this.acs.getUsername();
        this.signup.updateDisplayName(username, displayName);
        this.updateShowEmailAddressFacet(username, showEmailAddress);
    }

    @Override
    @GET
    @Path(value="/admin/workspaces")
    public List<RelatedTopic> getAllZWWorkspaces() {
        try {
            return DMXUtils.loadChildTopics((List)this.dmx.getTopicByUri("systems.dmx.linqa").getRelatedTopics("linqa.shared_workspace", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace"));
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving all ZW workspaces failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/admin/user/{username}/workspaces")
    public List<RelatedTopic> getZWWorkspacesOfUser(@PathParam(value="username") String username) {
        try {
            Topic usernameTopic = this.acs.getUsernameTopic(username);
            if (usernameTopic == null) {
                throw new IllegalArgumentException("No such user: \"" + username + "\"");
            }
            List<RelatedTopic> workspaces = this.getZWWorkspaces(usernameTopic);
            Assoc membership = this.acs.getMembership(username, this.teamWorkspace.getId());
            if (membership != null) {
                workspaces.add((RelatedTopic)membership.getDMXObjectByType("dmx.workspaces.workspace").loadChildTopics());
            }
            return workspaces;
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving ZW workspaces of user \"" + username + "\" failed", e);
        }
    }

    @Override
    public List<RelatedTopic> getZWTeamMembers() {
        return this.acs.getMemberships(this.teamWorkspace.getId());
    }

    @Override
    @PUT
    @Path(value="/admin/workspace/{workspaceId}")
    @Transactional
    public List<RelatedTopic> bulkUpdateWorkspaceMemberships(@PathParam(value="workspaceId") long workspaceId, @QueryParam(value="addUserIds1") IdList addUserIds1, @QueryParam(value="removeUserIds1") IdList removeUserIds1, @QueryParam(value="addUserIds2") IdList addUserIds2, @QueryParam(value="removeUserIds2") IdList removeUserIds2) {
        try {
            long userId;
            Iterator iterator;
            List users = this.acs.bulkUpdateMemberships(workspaceId, addUserIds1, removeUserIds1);
            if (removeUserIds2 != null) {
                iterator = removeUserIds2.iterator();
                while (iterator.hasNext()) {
                    userId = (Long)iterator.next();
                    this.updateEditorFacet(userId, workspaceId, false);
                }
            }
            if (addUserIds2 != null) {
                iterator = addUserIds2.iterator();
                while (iterator.hasNext()) {
                    userId = (Long)iterator.next();
                    this.updateEditorFacet(userId, workspaceId, true);
                }
            }
            return users;
        }
        catch (Exception e) {
            throw new RuntimeException("Editor role bulk update for ZW workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    @PUT
    @Path(value="/admin/user/{username}")
    @Transactional
    public List<RelatedTopic> bulkUpdateUserMemberships(@PathParam(value="username") String username, @QueryParam(value="addWorkspaceIds1") IdList addWorkspaceIds1, @QueryParam(value="removeWorkspaceIds1") IdList removeWorkspaceIds1, @QueryParam(value="addWorkspaceIds2") IdList addWorkspaceIds2, @QueryParam(value="removeWorkspaceIds2") IdList removeWorkspaceIds2) {
        try {
            long wsId;
            Iterator iterator;
            this.acs.bulkUpdateMemberships(username, addWorkspaceIds1, removeWorkspaceIds1);
            if (removeWorkspaceIds2 != null) {
                iterator = removeWorkspaceIds2.iterator();
                while (iterator.hasNext()) {
                    wsId = (Long)iterator.next();
                    this.updateEditorFacet(username, wsId, false);
                }
            }
            if (addWorkspaceIds2 != null) {
                iterator = addWorkspaceIds2.iterator();
                while (iterator.hasNext()) {
                    wsId = (Long)iterator.next();
                    this.updateEditorFacet(username, wsId, true);
                }
            }
            return this.getZWWorkspacesOfUser(username);
        }
        catch (Exception e) {
            throw new RuntimeException("Editor role bulk update for user \"" + username + "\" failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/admin/workspace")
    @Transactional
    public Topic createZWWorkspace(@QueryParam(value="nameDe") String nameDe, @QueryParam(value="nameFr") String nameFr) {
        try {
            Topic workspace = this.ws.createWorkspace(nameDe, null, SharingMode.COLLABORATIVE);
            workspace.update(this.mf.newChildTopicsModel().set("dmx.workspaces.workspace_name#linqa.de", (Object)nameDe).set("dmx.workspaces.workspace_name#linqa.fr", (Object)nameFr));
            long workspaceId = workspace.getId();
            this.dmx.getPrivilegedAccess().runInWorkspaceContext(workspaceId, () -> {
                this.dmx.createAssoc(this.mf.newAssocModel("linqa.shared_workspace", (PlayerModel)this.mf.newTopicPlayerModel("systems.dmx.linqa", "dmx.core.default"), (PlayerModel)this.mf.newTopicPlayerModel(workspaceId, "dmx.core.default")));
                return null;
            });
            this.createViewport(workspaceId);
            List<RelatedTopic> usernames = this.getZWTeamMembers();
            this.logger.info("### Inviting " + usernames.size() + " Team members to workspace \"" + workspace.getSimpleValue() + "\"");
            this.acs.bulkUpdateMemberships(workspaceId, new IdList(usernames), null);
            return workspace;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating a ZW workspace failed", e);
        }
    }

    private TopicModel createBilingualTopicModel(String topicTypeUri, String text) {
        return this.createBilingualTopicModel(topicTypeUri, text, topicTypeUri);
    }

    private TopicModel createBilingualTopicModel(String topicTypeUri, String text, String childTypeUri) {
        Translation translation = this.translate(text, null);
        String origLang = translation.detectedSourceLang;
        String targetLang = this.targetLang(origLang);
        return this.mf.newTopicModel(topicTypeUri, this.mf.newChildTopicsModel().set(childTypeUri + "." + origLang, (Object)text).set(childTypeUri + "." + targetLang, (Object)translation.text).set("linqa.language#linqa.original_language", (Object)origLang));
    }

    private String targetLang(String origLang) {
        if (origLang.equals("de")) {
            return "fr";
        }
        if (origLang.equals("fr")) {
            return "de";
        }
        throw new RuntimeException("Unsupported original language: \"" + origLang + "\" (detected)");
    }

    private Topic _createComment(TopicModel commentModel, IdList refTopicIds, IdList fileTopicIds) {
        Iterator iterator;
        if (refTopicIds != null) {
            iterator = refTopicIds.iterator();
            while (iterator.hasNext()) {
                long refTopicId = (Long)iterator.next();
                String compDefUri = this.dmx.getTopic(refTopicId).getTypeUri();
                commentModel.getChildTopics().setRef(compDefUri, refTopicId);
            }
        }
        if (fileTopicIds != null) {
            iterator = fileTopicIds.iterator();
            while (iterator.hasNext()) {
                long fileTopicId = (Long)iterator.next();
                commentModel.getChildTopics().addRef("dmx.files.file#linqa.attachment", fileTopicId);
            }
        }
        Topic commentTopic = this.dmx.createTopic(commentModel);
        this.acs.enrichWithUserInfo((DMXObject)commentTopic);
        this.timestamps.enrichWithTimestamps((DMXObject)commentTopic);
        this.me.addComment(this.workspaceId(), commentTopic);
        return commentTopic;
    }

    private void enrichWithColor(Topic topic) {
        long topicId = topic.getId();
        long topicmapId = this.topicmapId();
        Assoc assoc = this.tms.getTopicMapcontext(topicmapId, topicId);
        if (assoc != null && assoc.hasProperty("linqa.color")) {
            topic.getChildTopics().getModel().set("linqa.color", assoc.getProperty("linqa.color"));
        }
    }

    private void enrichWithUserActive(Topic username) {
        if (username.hasProperty("linqa.user_active")) {
            username.getChildTopics().getModel().set("linqa.user_active", username.getProperty("linqa.user_active"));
        }
    }

    private void processTeamMembership(Assoc assoc, Consumer<String> consumer) {
        Topic workspace;
        if (assoc.getTypeUri().equals("dmx.accesscontrol.membership") && (workspace = (Topic)assoc.getDMXObjectByType("dmx.workspaces.workspace")).getUri().equals("linqa.team")) {
            String username = assoc.getDMXObjectByType("dmx.accesscontrol.username").getSimpleValue().toString();
            consumer.accept(username);
        }
    }

    private List<RelatedTopic> getZWWorkspaces(Topic username) {
        return DMXUtils.loadChildTopics(username.getRelatedTopics("dmx.accesscontrol.membership", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace").stream().filter(this::isZWWorkspace).collect(Collectors.toList()));
    }

    private boolean isZWWorkspace(Topic workspace) {
        return this.dmx.getAssocBetweenTopicAndTopic("linqa.shared_workspace", workspace.getId(), this.zwPluginTopic.getId(), "dmx.core.default", "dmx.core.default") != null;
    }

    private long workspaceId() {
        return Cookies.get().getLong("dmx_workspace_id");
    }

    private long topicmapId() {
        return Cookies.get().getLong("dmx_topicmap_id");
    }

    private void updateEditorFacet(long userId, long workspaceId, boolean editor) throws Exception {
        this.updateEditorFacet(this.getUsername(userId), workspaceId, editor);
    }

    private void updateEditorFacet(String username, long workspaceId, boolean editor) throws Exception {
        this.dmx.getPrivilegedAccess().runInWorkspaceContext(workspaceId, () -> {
            Assoc assoc = this.acs.getMembership(username, workspaceId);
            if (assoc != null) {
                this.facets.updateFacet((DMXObject)assoc, "linqa.editor_facet", this.mf.newFacetValueModel("linqa.editor").set((Object)(workspaceId + ":" + editor)));
            }
            return null;
        });
    }

    private boolean getShowEmailAddress(String username) {
        try {
            Topic usernameTopic = this.acs.getUsernameTopic(username);
            RelatedTopic showEmailAddress = this.facets.getFacet((DMXObject)usernameTopic, "linqa.show_email_address_facet");
            if (showEmailAddress != null) {
                return showEmailAddress.getSimpleValue().booleanValue();
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching \"Show Email Address\" flag of user \"" + username + "\" failed", e);
        }
    }

    private void updateShowEmailAddressFacet(String username, boolean showEmailAddress) {
        try {
            PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
            pa.runInWorkspaceContext(this.getDisplayNamesWorkspaceId(), () -> {
                Topic usernameTopic = this.acs.getUsernameTopic(username);
                if (usernameTopic != null) {
                    this.facets.updateFacet((DMXObject)usernameTopic, "linqa.show_email_address_facet", this.mf.newFacetValueModel("linqa.show_email_address").set((Object)showEmailAddress));
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Updating \"Show Email Address\" flag (" + showEmailAddress + ") of user \"" + username + "\" failed", e);
        }
    }

    private String getUsername(long id) {
        Topic username = this.dmx.getTopic(id);
        String typeUri = username.getTypeUri();
        if (!typeUri.equals("dmx.accesscontrol.username")) {
            throw new IllegalArgumentException("Topic " + id + " is not a Username (but a \"" + typeUri + "\")");
        }
        return username.getSimpleValue().toString();
    }

    private long getDisplayNamesWorkspaceId() {
        return this.dmx.getTopicByUri("dmx.signup.display_names_ws").getId();
    }
}

