/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.linqa.migrations;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.workspaces.WorkspacesService;

public class Migration4
extends Migration {
    @Inject
    private WorkspacesService ws;
    private Map<String, Integer> repaired = new HashMap<String, Integer>();
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        for (Topic workspace : this.dmx.getTopicsByType("dmx.workspaces.workspace")) {
            int r = this.repair(workspace, "dmx.workspaces.workspace_name#linqa.lang1") + this.repair(workspace, "dmx.workspaces.workspace_name#linqa.lang2");
            if (r <= 0) continue;
            this.repaired.put(workspace.getSimpleValue().toString(), r);
        }
        this.logger.info("##### Repaired workspaces: " + this.repaired.size() + "\n  " + this.repaired.keySet().stream().map(ws -> "\"" + ws + "\" (" + this.repaired.get(ws) + " assocs)").collect(Collectors.joining("\n  ")));
    }

    private int repair(Topic workspace, String compDefUri) {
        Assoc assoc;
        Topic _workspace;
        RelatedTopic topic = workspace.getChildTopics().getTopicOrNull(compDefUri);
        if (topic != null && (_workspace = this.ws.getAssignedWorkspace((assoc = topic.getRelatingAssoc()).getId())) != null) {
            this.ws.assignToWorkspace((DMXObject)assoc, -1L);
            return 1;
        }
        return 0;
    }
}

