/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.linqa;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.files.UploadedFile;

class ImageScaler {
    final float MAX_PIXEL = 1024.0f;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ImageScaler() {
    }

    UploadedFile scale(UploadedFile imageFile) {
        try {
            InputStream in = imageFile.getInputStream();
            String name = imageFile.getName();
            String format = JavaUtils.getExtension((String)name);
            BufferedImage image = ImageIO.read(in);
            int width = image.getWidth();
            int height = image.getHeight();
            int max = Math.max(width, height);
            if ((float)max > 1024.0f) {
                float scale = 1024.0f / (float)max;
                int targetWidth = (int)((float)width * scale);
                int targetHeight = (int)((float)height * scale);
                this.logger.info("Original " + width + "x" + height + " -> " + targetWidth + "x" + targetHeight + "(scale=" + scale + ")");
                BufferedImage scaledImage = new BufferedImage(targetWidth, targetHeight, 1);
                Graphics2D g = scaledImage.createGraphics();
                g.drawImage(image, 0, 0, targetWidth, targetHeight, null);
                g.dispose();
                image = scaledImage;
            } else {
                this.logger.info("Size " + width + "x" + height + " (no scaling needed)");
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(){

                @Override
                public synchronized byte[] toByteArray() {
                    return this.buf;
                }
            };
            ImageIO.write((RenderedImage)image, format, out);
            int size = out.size();
            ByteArrayInputStream scaledIn = new ByteArrayInputStream(out.toByteArray(), 0, size);
            return new UploadedFile(name, (long)size, (InputStream)scaledIn);
        }
        catch (Exception e) {
            throw new RuntimeException("Storing scaled image failed", e);
        }
    }
}

