/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.linqa;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.files.UploadedFile;

class ImageScaler {
    final float MAX_PIXEL = 1024.0f;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ImageScaler() {
    }

    UploadedFile scale(UploadedFile imageFile) {
        try {
            imageFile.setBuffered();
            InputStream in = imageFile.getInputStream();
            BufferedImage image = ImageIO.read(in);
            int width = image.getWidth();
            int height = image.getHeight();
            int max = Math.max(width, height);
            if ((float)max <= 1024.0f) {
                this.logger.info("Size " + width + "x" + height + " (no scaling needed)");
                in.reset();
                return imageFile;
            }
            float scale = 1024.0f / (float)max;
            int targetWidth = (int)((float)width * scale);
            int targetHeight = (int)((float)height * scale);
            this.logger.info("Original " + width + "x" + height + " -> " + targetWidth + "x" + targetHeight + " (scale=" + scale + ")");
            BufferedImage scaledImage = this.createScaledImage(image, targetWidth, targetHeight);
            return this.outputImage(scaledImage, imageFile.getName());
        }
        catch (Exception e) {
            throw new RuntimeException("ImageScaler failed", e);
        }
    }

    private BufferedImage createScaledImage(BufferedImage image, int width, int height) {
        BufferedImage scaledImage = new BufferedImage(width, height, 1);
        Graphics2D g = scaledImage.createGraphics();
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return scaledImage;
    }

    private UploadedFile outputImage(BufferedImage image, String fileName) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(){

                @Override
                public synchronized byte[] toByteArray() {
                    return this.buf;
                }
            };
            String format = JavaUtils.getExtension((String)fileName);
            ImageIO.write((RenderedImage)image, format, out);
            int size = out.size();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray(), 0, size);
            return new UploadedFile(fileName, (long)size, (InputStream)in);
        }
        catch (Exception e) {
            throw new RuntimeException("Output image failed", e);
        }
    }
}

