/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.linqa.migrations;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.CharacterReader;
import org.jsoup.select.Elements;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.files.FilesService;
import systems.dmx.files.UploadedFile;
import systems.dmx.linqa.ImageScaler;

public class Migration3
extends Migration {
    private static final String IMAGE_FILE_NAME = "zw-image-%d.%s";
    private static final String STATS = "  %-20s - topics: %3d, image tags: %3d, data-URLs: %3d, images: %3d, duplicates: %3d -> %3d repo files created\n";
    @Inject
    private FilesService files;
    private Map<String, String> storedImages = new HashMap<String, String>();
    private int imageCount = 0;
    private Map<String, int[]> stats = new TreeMap<String, int[]>();
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.transformImages("linqa.note");
        this.transformImages("linqa.note_text");
        this.transformImages("linqa.textblock");
        this.transformImages("linqa.textblock_text");
        this.transformImages("linqa.comment");
        this.transformImages("linqa.comment_text");
        StringBuilder sb = new StringBuilder();
        this.stats.keySet().stream().forEach(typeUri -> sb.append(String.format(STATS, typeUri, this.stats.get(typeUri)[0], this.stats.get(typeUri)[1], this.stats.get(typeUri)[2], this.stats.get(typeUri)[3], this.stats.get(typeUri)[4], this.stats.get(typeUri)[3] - this.stats.get(typeUri)[4])));
        this.logger.info("##### Image data-URL migration complete #####\n" + sb);
    }

    private void transformImages(String typeUri) {
        this.stats.put(typeUri, new int[5]);
        this.dmx.getTopicsByType(typeUri).stream().forEach(topic -> {
            this.inc(typeUri, 0);
            String html = topic.getSimpleValue().toString();
            Document doc = Jsoup.parseBodyFragment((String)html);
            Document.OutputSettings settings = doc.outputSettings();
            settings.prettyPrint(false);
            Elements images = doc.select("img");
            boolean hasDataUrl = false;
            for (Element image : images) {
                this.inc(typeUri, 1);
                if (!this.transformImageTag(image, (Topic)topic)) continue;
                hasDataUrl = true;
            }
            if (hasDataUrl) {
                String newHtml = doc.body().html();
                this.logger.info("Transformed HTML: " + newHtml);
                topic.setSimpleValue(newHtml);
            }
        });
    }

    private boolean transformImageTag(Element image, Topic topic) {
        String src = image.attr("src");
        String typeUri = topic.getTypeUri();
        StringBuilder log = new StringBuilder();
        log.append("---------------------------------------- " + typeUri + " (" + topic.getId() + ")\n" + src.substring(0, Math.min(src.length(), 40)) + " -> ");
        if (!src.startsWith("data:")) {
            log.append("not a data-URL");
            this.logger.info(log.toString());
            return false;
        }
        this.inc(typeUri, 2);
        CharacterReader reader = new CharacterReader(src);
        reader.consumeTo(':');
        reader.advance();
        String mimeType = reader.consumeTo(';');
        reader.advance();
        String category = mimeType.split("/")[0];
        if (!category.equals("image")) {
            log.append("not an image! Removing <img> tag ...");
            this.logger.info(log.toString());
            image.remove();
            return true;
        }
        this.inc(typeUri, 3);
        String encoding = reader.consumeTo(',');
        reader.advance();
        if (!encoding.equals("base64")) {
            throw new RuntimeException("Unexpected encoding: \"" + encoding + "\"");
        }
        String base64 = src.substring(reader.pos());
        log.append("mimeType=\"" + mimeType + "\", encoding=\"" + encoding + "\", size=" + base64.length());
        this.logger.info(log.toString());
        String url = this.writeImageFile(base64, mimeType, typeUri);
        image.attr("src", url);
        return true;
    }

    private String writeImageFile(String base64, String mimeType, String typeUri) {
        try {
            String url = this.storedImages.get(base64);
            if (url != null) {
                this.logger.info("Duplicate already stored (" + url + ")");
                this.inc(typeUri, 4);
                return url;
            }
            String extension = mimeType.split("/")[1];
            String fileName = String.format(IMAGE_FILE_NAME, ++this.imageCount, extension);
            byte[] bytes = Base64.getDecoder().decode(base64);
            UploadedFile imageFile = new UploadedFile(fileName, (long)bytes.length, (InputStream)new ByteArrayInputStream(bytes));
            UploadedFile scaledImage = new ImageScaler().scale(imageFile);
            String repoPath = this.files.storeFile(scaledImage, "/").getRepoPath();
            url = "/filerepo/" + JavaUtils.encodeURIComponent((String)repoPath);
            this.storedImages.put(base64, url);
            return url;
        }
        catch (Exception e) {
            throw new RuntimeException("Writing image file failed", e);
        }
    }

    void inc(String typeUri, int item) {
        int[] nArray = this.stats.get(typeUri);
        int n = item;
        nArray[n] = nArray[n] + 1;
    }
}

