/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.linqa;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.files.UploadedFile;

public class ImageScaler {
    private static final int MAX_IMAGE_SIZE = 1024;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public UploadedFile scale(UploadedFile originalImage) {
        try {
            originalImage.setBuffered();
            InputStream in = originalImage.getInputStream();
            BufferedImage image = ImageIO.read(in);
            if (image == null) {
                throw new RuntimeException("Original image could not be read");
            }
            in.reset();
            int width = image.getWidth();
            int height = image.getHeight();
            int max = Math.max(width, height);
            if (max <= 1024) {
                this.logger.info("Size " + width + "x" + height + " (no scaling needed)");
                return null;
            }
            float scale = 1024.0f / (float)max;
            int targetWidth = (int)((float)width * scale);
            int targetHeight = (int)((float)height * scale);
            this.logger.info("Original " + width + "x" + height + " -> " + targetWidth + "x" + targetHeight + " (scale=" + scale + ")");
            BufferedImage scaledImage = this.createScaledImage(image, targetWidth, targetHeight);
            return this.outputScaledImage(scaledImage, originalImage.getName());
        }
        catch (Exception e) {
            throw new RuntimeException("ImageScaler failed", e);
        }
    }

    private BufferedImage createScaledImage(BufferedImage image, int width, int height) {
        BufferedImage scaledImage = new BufferedImage(width, height, 1);
        Graphics2D g = scaledImage.createGraphics();
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return scaledImage;
    }

    private UploadedFile outputScaledImage(BufferedImage image, String fileName) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(){

                @Override
                public synchronized byte[] toByteArray() {
                    return this.buf;
                }
            };
            String basename = JavaUtils.getBasename((String)fileName);
            String format = JavaUtils.getExtension((String)fileName);
            String scaledFilename = basename + "-" + 1024 + "." + format;
            ImageIO.write((RenderedImage)image, format, out);
            int size = out.size();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray(), 0, size);
            return new UploadedFile(scaledFilename, (long)size, (InputStream)in);
        }
        catch (Exception e) {
            throw new RuntimeException("Output image failed", e);
        }
    }
}

