/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.linqa;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.service.CoreService;
import systems.dmx.sendmail.SendmailService;
import systems.dmx.timestamps.TimestampsService;
import systems.dmx.workspaces.WorkspacesService;

class EmailDigests {
    static final String DIGEST_EMAIL_SUBJECT = System.getProperty("dmx.linqa.digest_email_subject", "Linqa Platform");
    static final int DIGEST_EMAIL_HOUR = Integer.getInteger("dmx.linqa.digest_email_hour", 6);
    static final long MILLISECS_PER_DAY = 86400000L;
    private CoreService dmx;
    private AccessControlService acs;
    private WorkspacesService ws;
    private TimestampsService timestamps;
    private SendmailService sendmail;
    private Topic linqaAdminWs;
    private int digestCount;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    EmailDigests(CoreService dmx, AccessControlService acs, WorkspacesService ws, TimestampsService timestamps, SendmailService sendmail, Topic linqaAdminWs) {
        this.dmx = dmx;
        this.acs = acs;
        this.ws = ws;
        this.timestamps = timestamps;
        this.sendmail = sendmail;
        this.linqaAdminWs = linqaAdminWs;
    }

    void startTimedTask() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, DIGEST_EMAIL_HOUR);
        cal.set(12, 0);
        cal.set(13, 0);
        this.logger.info(String.format("### Sheduling email-digests task for daily execution at %d:00, first execution: %s", DIGEST_EMAIL_HOUR, cal.getTime()));
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                EmailDigests.this.sendEmailDigests();
            }
        }, cal.getTime(), 86400000L);
    }

    private void sendEmailDigests() {
        try {
            long to = System.currentTimeMillis();
            this.digestCount = 0;
            this.timestamps.getTopicsByModificationTime(to - 86400000L, to).stream().filter(this::isComment).collect(Collectors.groupingBy(this::workspace)).forEach((workspaceId, comments) -> {
                String workspace = this.dmx.getTopic(workspaceId.longValue()).getSimpleValue().toString();
                String subject = String.format("[%s] %s", DIGEST_EMAIL_SUBJECT, workspace);
                StringBuilder message = new StringBuilder();
                this.logger.info("### Sending email digest for workspace \"" + workspace + "\" (" + comments.size() + " comments)");
                comments.forEach(comment -> {
                    this.timestamps.enrichWithTimestamps((DMXObject)comment);
                    this.acs.enrichWithUserInfo((DMXObject)comment);
                });
                comments.sort((c1, c2) -> {
                    long d = c1.getModel().getChildTopics().getLong("dmx.timestamps.modified") - c2.getModel().getChildTopics().getLong("dmx.timestamps.modified");
                    return d < 0L ? -1 : (d == 0L ? 0 : 1);
                });
                comments.forEach(comment -> message.append(this.emailMessage((Topic)comment)));
                this.forEachLinqaAdmin(username -> this.sendmail.doEmailRecipient(subject, null, message.toString(), username));
                ++this.digestCount;
            });
            if (this.digestCount == 0) {
                this.logger.info("### Sending email digests SKIPPED -- no new/changed comment in last 24 hours");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Sending email digests failed", e);
        }
    }

    private boolean isComment(Topic topic) {
        return topic.getTypeUri().equals("linqa.comment");
    }

    private Long workspace(Topic comment) {
        return this.ws.getAssignedWorkspace(comment.getId()).getId();
    }

    private String emailMessage(Topic comment) {
        String commentLang1 = comment.getChildTopics().getString("linqa.comment_text#linqa.lang1");
        String commentLang2 = comment.getChildTopics().getString("linqa.comment_text#linqa.lang2", "");
        String creator = comment.getModel().getChildTopics().getString("dmx.accesscontrol.creator");
        long modified = comment.getModel().getChildTopics().getLong("dmx.timestamps.modified");
        return "<br>\nAuthor: " + creator + "<br>\nDate: " + new Date(modified) + "<br><br>\n\n" + commentLang1 + "\n>>>\n" + commentLang2 + "\n\n------------------------------------------------<br>\n";
    }

    private void forEachLinqaAdmin(Consumer<String> consumer) {
        this.getLinqaAdmins().stream().forEach(username -> consumer.accept(username.getSimpleValue().toString()));
    }

    private List<RelatedTopic> getLinqaAdmins() {
        return this.acs.getMemberships(this.linqaAdminWs.getId());
    }
}

