/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.linqa;

import java.io.File;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Topic;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.linqa.StringProvider;
import systems.dmx.sendmail.SendmailService;
import systems.dmx.signup.SignupService;
import systems.dmx.timestamps.TimestampsService;
import systems.dmx.workspaces.WorkspacesService;

public class EmailDigests {
    static final String DIGEST_EMAIL_SUBJECT = System.getProperty("dmx.linqa.digest_email_subject", "Linqa Platform");
    static final int DIGEST_EMAIL_HOUR = Integer.getInteger("dmx.linqa.digest_email_hour", 6);
    static final String HOST_URL = System.getProperty("dmx.host.url", "");
    static final long MILLISECS_PER_DAY = 86400000L;
    private CoreService dmx;
    private AccessControlService acs;
    private WorkspacesService ws;
    private TimestampsService timestamps;
    private SendmailService sendmail;
    private SignupService signup;
    private String emailTemplate;
    private String commentTemplate;
    private StringProvider sp;
    private String lang1;
    private String lang2;
    private int digestCount;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    EmailDigests(CoreService dmx, AccessControlService acs, WorkspacesService ws, TimestampsService timestamps, SendmailService sendmail, SignupService signup, String emailTemplate, String commentTemplate, StringProvider sp, String lang1, String lang2) {
        this.dmx = dmx;
        this.acs = acs;
        this.ws = ws;
        this.timestamps = timestamps;
        this.sendmail = sendmail;
        this.signup = signup;
        this.emailTemplate = emailTemplate;
        this.commentTemplate = commentTemplate;
        this.sp = sp;
        this.lang1 = lang1;
        this.lang2 = lang2;
    }

    void startTimedTask() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, DIGEST_EMAIL_HOUR);
        cal.set(12, 0);
        cal.set(13, 0);
        this.logger.info(String.format("### Sheduling email-digests task for daily execution at %d:00, first execution: %s", DIGEST_EMAIL_HOUR, cal.getTime()));
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                EmailDigests.this.sendEmailDigests();
            }
        }, cal.getTime(), 86400000L);
    }

    private void sendEmailDigests() {
        try {
            long to = System.currentTimeMillis();
            this.digestCount = 0;
            this.timestamps.getTopicsByModificationTime(to - 86400000L, to).stream().filter(this::isComment).collect(Collectors.groupingBy(this::workspace)).forEach((workspaceId, comments) -> this.acs.getMemberships(workspaceId.longValue()).forEach(username -> this.sendDigestToUser((Topic)username, (List<Topic>)comments, (long)workspaceId)));
            if (this.digestCount == 0) {
                this.logger.info("### Sending email digests SKIPPED -- no new/changed comment in last 24 hours");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Sending email digests failed", e);
        }
    }

    private void sendDigestToUser(Topic username, List<Topic> comments, long workspaceId) {
        String _username = username.getSimpleValue().toString();
        String workspaceName = this.dmx.getTopic(workspaceId).getSimpleValue().toString();
        this.logger.info(String.format("###### Sending email digest to user \"%s\" (%d) of workspace \"%s\" (filtering %d comments)", _username, username.getId(), workspaceName, comments.size()));
        String commentsHtml = this.commentsHtml(comments, username);
        if (!commentsHtml.isEmpty()) {
            String displayName = this.signup.getDisplayName(_username);
            NotificationLevel notificationLevel = NotificationLevel.get(username);
            String workspaceUrl = "/#/workspace/" + workspaceId;
            String userProfileUrl = "/#/login?profile=notifications";
            File file = this.getExternalResourceFile("digest-custom.css");
            String customCSS = file.exists() ? JavaUtils.readTextFile((File)file) : "";
            String header1 = this.sp.getString(this.lang1, "digest_mail.header", displayName, workspaceName);
            String header2 = this.sp.getString(this.lang2, "digest_mail.header", displayName, workspaceName);
            String footer1 = this.sp.getString(this.lang1, "digest_mail.footer", new Object[]{workspaceUrl, notificationLevel, userProfileUrl});
            String footer2 = this.sp.getString(this.lang2, "digest_mail.footer", new Object[]{workspaceUrl, notificationLevel, userProfileUrl});
            String subject = String.format("[%s] %s", DIGEST_EMAIL_SUBJECT, workspaceName);
            String digestHtml = String.format(this.emailTemplate, HOST_URL, customCSS, this.lang1, this.lang2, header1, header2, commentsHtml, footer1, footer2);
            this.sendmail.doEmailRecipient(subject, null, digestHtml, _username);
            ++this.digestCount;
        } else {
            this.logger.info("--> Nothing to send for user \"" + _username + "\"");
        }
    }

    private String commentsHtml(List<Topic> comments, Topic username) {
        NotificationLevel notificationLevel = NotificationLevel.get(username);
        return comments.stream().filter(comment -> this.commentFilter((Topic)comment, username, notificationLevel)).map(comment -> {
            this.timestamps.enrichWithTimestamps((DMXObject)comment);
            this.acs.enrichWithUserInfo((DMXObject)comment);
            return comment;
        }).sorted((c1, c2) -> {
            long d = c1.getModel().getChildTopics().getLong("dmx.timestamps.modified") - c2.getModel().getChildTopics().getLong("dmx.timestamps.modified");
            return d < 0L ? -1 : (d == 0L ? 0 : 1);
        }).reduce(new StringBuilder(), (builder, comment) -> builder.append(this.commentHtml((Topic)comment)), (builder1, builder2) -> builder1.append((CharSequence)builder2)).toString();
    }

    private boolean commentFilter(Topic comment, Topic username, NotificationLevel notificationLevel) {
        this.logger.info("### comment " + comment.getId());
        switch (notificationLevel) {
            case ALL: {
                this.logger.info("   ALL --> true");
                return true;
            }
            case NONE: {
                this.logger.info("   NONE --> false");
                return false;
            }
            case MENTIONED: {
                String html = comment.getSimpleValue().toString();
                Document doc = Jsoup.parseBodyFragment((String)html);
                Elements mentions = doc.select("span.mention");
                for (Element mention : mentions) {
                    long id = Long.parseLong((String)mention.dataset().get("id"));
                    boolean match = id == username.getId() || id == -1L;
                    this.logger.info("   --> mention username " + id + ", match=" + match);
                    if (!match) continue;
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("Unexpected notification level: " + (Object)((Object)notificationLevel));
    }

    private boolean isComment(Topic topic) {
        return topic.getTypeUri().equals("linqa.comment");
    }

    private Long workspace(Topic comment) {
        return this.ws.getAssignedWorkspace(comment.getId()).getId();
    }

    private String commentHtml(Topic comment) {
        String comment1 = comment.getChildTopics().getString("linqa.comment_text#linqa.lang1");
        String comment2 = comment.getChildTopics().getString("linqa.comment_text#linqa.lang2", "");
        String username = comment.getModel().getChildTopics().getString("dmx.accesscontrol.creator");
        long modified = comment.getModel().getChildTopics().getLong("dmx.timestamps.modified");
        String author = this.signup.getDisplayName(username);
        return String.format(this.commentTemplate, author, new Date(modified), this.imgWidth(comment1), this.imgWidth(comment2));
    }

    private String imgWidth(String commentHtml) {
        Document doc = Jsoup.parseBodyFragment((String)commentHtml);
        Document.OutputSettings settings = doc.outputSettings();
        settings.prettyPrint(false);
        Elements images = doc.select("img");
        for (Element image : images) {
            image.attr("width", "300");
        }
        return doc.body().html();
    }

    private File getExternalResourceFile(String path) {
        return new File(DMXUtils.getConfigDir() + "dmx-linqa/" + path);
    }

    public static enum NotificationLevel {
        ALL,
        MENTIONED,
        NONE;


        public static NotificationLevel get(Topic username) {
            return username.hasProperty("linqa.notification_level") ? NotificationLevel.fromString((String)username.getProperty("linqa.notification_level")) : MENTIONED;
        }

        public static String getAsString(Topic username) {
            return NotificationLevel.get(username).toString();
        }

        public static void set(Topic username, NotificationLevel notificationLevel) {
            username.setProperty("linqa.notification_level", (Object)notificationLevel.toString(), false);
        }

        public static NotificationLevel fromString(String notificationLevel) {
            return NotificationLevel.valueOf(notificationLevel.toUpperCase());
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

