/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.linqa;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.jcodec.api.FrameGrab;
import org.jcodec.common.model.Picture;
import org.jcodec.scale.AWTUtil;
import systems.dmx.core.Topic;
import systems.dmx.core.service.CoreService;
import systems.dmx.files.FilesService;

public class VideoFrameGrabber {
    private static final int SEEK_IN_SECS = 2;
    private CoreService dmx;
    private FilesService fs;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public VideoFrameGrabber(CoreService dmx, FilesService fs) {
        this.dmx = dmx;
        this.fs = fs;
    }

    public boolean createPosterFrame(Topic topic) {
        try {
            if (topic.getTypeUri().equals("dmx.files.file") && topic.getChildTopics().getString("dmx.files.media_type", "").startsWith("video/")) {
                this.logger.info("\"" + topic.getChildTopics().getString("dmx.files.path", "") + "\"");
                File file = this.fs.getFile(topic.getId());
                Picture picture = FrameGrab.getFrameAtSec((File)file, (double)2.0);
                BufferedImage image = AWTUtil.toBufferedImage((Picture)picture);
                ImageIO.write((RenderedImage)image, "png", new File(this.replaceExtension(file.getPath(), ".png")));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating poster frame for file topic " + topic.getId() + " failed, path=\"" + topic.getChildTopics().getString("dmx.files.path", "") + "\", mediaType=\"" + topic.getChildTopics().getString("dmx.files.media_type", "") + "\"", e);
        }
    }

    private String replaceExtension(String path, String newExt) {
        return path.substring(0, path.lastIndexOf(46)) + newExt;
    }
}

