/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.linqa;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Logger;
import org.jcodec.api.FrameGrab;
import org.jcodec.common.model.Picture;
import org.jcodec.scale.AWTUtil;
import systems.dmx.core.Topic;
import systems.dmx.core.service.CoreService;
import systems.dmx.files.FilesService;
import systems.dmx.files.UploadedFile;
import systems.dmx.linqa.ImageInputStream;

public class VideoFrameGrabber {
    private static final int SEEK_IN_SECS = 2;
    private CoreService dmx;
    private FilesService fs;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public VideoFrameGrabber(CoreService dmx, FilesService fs) {
        this.dmx = dmx;
        this.fs = fs;
    }

    public boolean createPosterFrame(Topic topic) {
        try {
            if (topic.getTypeUri().equals("dmx.files.file") && topic.getChildTopics().getString("dmx.files.media_type", "").startsWith("video/")) {
                this.logger.info("\"" + topic.getChildTopics().getString("dmx.files.path", "") + "\"");
                File video = this.fs.getFile(topic.getId());
                Picture picture = FrameGrab.getFrameAtSec((File)video, (double)2.0);
                BufferedImage image = AWTUtil.toBufferedImage((Picture)picture);
                String filename = this.replaceExtension(video.getName(), "png");
                UploadedFile uf = new ImageInputStream(image, "png", filename).get();
                this.fs.createFile(uf.getInputStream(), this.fs.pathPrefix() + "/" + filename);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating poster frame for file topic " + topic.getId() + " failed, path=\"" + topic.getChildTopics().getString("dmx.files.path", "") + "\", mediaType=\"" + topic.getChildTopics().getString("dmx.files.media_type", "") + "\"", e);
        }
    }

    private String replaceExtension(String path, String newExt) {
        return path.substring(0, path.lastIndexOf(46) + 1) + newExt;
    }
}

