/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.linqa.migrations;

import java.util.logging.Logger;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.files.FilesService;
import systems.dmx.linqa.VideoFrameGrabber;

public class Migration9
extends Migration {
    @Inject
    private FilesService fs;
    private int docs = 0;
    private int files = 0;
    private int videos = 0;
    private int posterframes = 0;
    private int errors = 0;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("##### Migration 9: Creating video poster frames ...");
        this.dmx.getTopicsByType("linqa.document").stream().forEach(doc -> {
            ++this.docs;
            this.createPosterFrame((Topic)doc.getChildTopics().getTopicOrNull("dmx.files.file#linqa.lang1"));
            this.createPosterFrame((Topic)doc.getChildTopics().getTopicOrNull("dmx.files.file#linqa.lang2"));
        });
        this.logger.info(String.format("### Video poster frame migration complete\n  Documents: %d\n  Files: %d\n  Videos: %d\n  Poster frames created: %d\n  Errors: %d", this.docs, this.files, this.videos, this.posterframes, this.errors));
    }

    private void createPosterFrame(Topic file) {
        try {
            if (file != null) {
                ++this.files;
                if (new VideoFrameGrabber(this.dmx, this.fs).createPosterFrame(file)) {
                    ++this.videos;
                    ++this.posterframes;
                }
            }
        }
        catch (Exception e) {
            ++this.videos;
            ++this.errors;
            this.logger.warning(this.dumpException(e));
        }
    }

    private String dumpException(Throwable e) {
        StringBuilder builder = new StringBuilder(e.toString());
        while ((e = e.getCause()) != null) {
            builder.append(", cause: " + e.getCause());
        }
        return builder.toString();
    }
}

