/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.linqa;

import com.sun.jersey.core.util.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.accesscontrol.event.PostLoginUser;
import systems.dmx.core.Assoc;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.model.topicmaps.ViewTopic;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Cookies;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.PrivilegedAccess;
import systems.dmx.core.service.accesscontrol.SharingMode;
import systems.dmx.core.service.event.PostCreateAssoc;
import systems.dmx.core.service.event.PostCreateTopic;
import systems.dmx.core.service.event.PreDeleteAssoc;
import systems.dmx.core.service.event.PreSendTopic;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.core.util.IdList;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.deepl.DeepLService;
import systems.dmx.deepl.Translation;
import systems.dmx.facets.FacetsService;
import systems.dmx.files.FilesService;
import systems.dmx.files.StoredFile;
import systems.dmx.files.UploadedFile;
import systems.dmx.linqa.EmailDigests;
import systems.dmx.linqa.ImageScaler;
import systems.dmx.linqa.LinqaEmailTextProducer;
import systems.dmx.linqa.LinqaService;
import systems.dmx.linqa.Messenger;
import systems.dmx.linqa.StringProvider;
import systems.dmx.linqa.UTF8Control;
import systems.dmx.linqa.VideoFrameGrabber;
import systems.dmx.sendmail.SendmailService;
import systems.dmx.signup.EmailTextProducer;
import systems.dmx.signup.SignupService;
import systems.dmx.timestamps.TimestampsService;
import systems.dmx.topicmaps.TopicmapCustomizer;
import systems.dmx.topicmaps.TopicmapsService;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/linqa")
@Produces(value={"application/json"})
public class LinqaPlugin
extends PluginActivator
implements LinqaService,
TopicmapCustomizer,
PostCreateTopic,
PostCreateAssoc,
PreDeleteAssoc,
PreSendTopic,
PostLoginUser {
    private static final String CONFIG_LANG1 = System.getProperty("dmx.linqa.lang1");
    private static final String CONFIG_LANG2 = System.getProperty("dmx.linqa.lang2");
    private static final String HOST_URL = System.getProperty("dmx.host.url", "");
    private static final String DEFAULT_HELP_LANG = "en";
    @Inject
    private DeepLService deepls;
    @Inject
    private TimestampsService timestamps;
    @Inject
    private TopicmapsService tms;
    @Inject
    private WorkspacesService ws;
    @Inject
    private AccessControlService acs;
    @Inject
    private FacetsService facets;
    @Inject
    private FilesService files;
    @Inject
    private SignupService signup;
    @Inject
    private SendmailService sendmail;
    private Topic zwPluginTopic;
    private Topic linqaAdminWs;
    private StringProvider sp = new LinqaStringProvider();
    private Messenger me;
    private Random random = new Random();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public void init() {
        this.zwPluginTopic = this.dmx.getTopicByUri("systems.dmx.linqa");
        this.linqaAdminWs = this.dmx.getTopicByUri("linqa.admin_ws");
        this.tms.registerTopicmapCustomizer((TopicmapCustomizer)this);
        this.signup.setEmailTextProducer((EmailTextProducer)new LinqaEmailTextProducer(this.sp));
        this.me = new Messenger(this.dmx.getWebSocketService());
        new EmailDigests(this.dmx, this.acs, this.ws, this.timestamps, this.sendmail, this.signup, JavaUtils.readTextURL((URL)this.bundle.getResource("/app-strings/digest-template.html")), JavaUtils.readTextURL((URL)this.bundle.getResource("/app-strings/comment-template.html")), this.sp, CONFIG_LANG1, CONFIG_LANG2).startTimedTask();
    }

    public void shutdown() {
        this.tms.unregisterTopicmapCustomizer((TopicmapCustomizer)this);
    }

    public void postCreateTopic(Topic topic) {
        new VideoFrameGrabber(this.dmx, this.files).createPosterFrame(topic);
    }

    public void postCreateAssoc(Assoc assoc) {
        this.processLinqaAdminMembership(assoc, (usernameTopic, username) -> {
            this.logger.info("### Inviting user \"" + username + "\" to \"System\" workspace");
            this.acs.createMembership(username, this.dmx.getPrivilegedAccess().getSystemWorkspaceId());
            List<RelatedTopic> workspaces = this.getAllLinqaWorkspaces();
            this.logger.info("### Inviting user \"" + username + "\" to " + workspaces.size() + " Linqa workspaces");
            this.acs.bulkUpdateMemberships(username, new IdList(workspaces), null);
            EmailDigests.NotificationLevel.set(usernameTopic, EmailDigests.NotificationLevel.ALL);
        });
    }

    public void preDeleteAssoc(Assoc assoc) {
        this.processLinqaAdminMembership(assoc, (usernameTopic, username) -> {
            this.logger.info("### Removing \"System\" membership from user \"" + username + "\"");
            Assoc systemMembership = this.acs.getMembership(username, this.dmx.getPrivilegedAccess().getSystemWorkspaceId());
            if (systemMembership != null) {
                systemMembership.delete();
            }
        });
    }

    public void preSendTopic(Topic topic) {
        RelatedTopic editor;
        Assoc assoc;
        String typeUri = topic.getTypeUri();
        if (typeUri.equals("linqa.comment")) {
            this.enrichComment(topic);
        } else if (typeUri.equals("dmx.workspaces.workspace")) {
            this.acs.enrichWithOwnerInfo(topic);
        } else if (typeUri.equals("dmx.accesscontrol.username")) {
            String username = topic.getSimpleValue().toString();
            ChildTopicsModel topics = topic.getChildTopics().getModel();
            String displayName = this.signup.getDisplayName(username);
            if (displayName != null) {
                topics.set("dmx.signup.display_name", (Object)displayName);
            }
            topics.set("linqa.show_email_address", (Object)this.getShowEmailAddress(username));
            this.enrichWithUsernameProps(topic);
        }
        if (topic instanceof RelatedTopic && (assoc = ((RelatedTopic)topic).getRelatingAssoc()).getTypeUri().equals("dmx.accesscontrol.membership") && (editor = this.facets.getFacet((DMXObject)assoc, "linqa.editor_facet")) != null) {
            String[] a = editor.getSimpleValue().toString().split(":");
            boolean isEditor = Boolean.parseBoolean(a[1]);
            assoc.getChildTopics().getModel().set("linqa.editor", (Object)isEditor);
        }
    }

    public void postLoginUser(String username) {
        DMXTransaction tx = this.dmx.beginTx();
        try {
            this.acs.getUsernameTopic(username).setProperty("linqa.user_active", (Object)true, false);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public void customizeTopic(RelatedTopic topic, ViewProps viewProps) {
        this.fetchLinqaViewProps(topic.getTypeUri(), topic.getRelatingAssoc(), viewProps);
        this.enrichWithColor((Topic)topic, viewProps);
    }

    @Override
    @GET
    @Path(value="/config/lang")
    public List<String> getLanguageConfig() {
        ArrayList<String> langs = new ArrayList<String>();
        langs.add(CONFIG_LANG1);
        langs.add(CONFIG_LANG2);
        return langs;
    }

    @Override
    @GET
    @Path(value="/help")
    public List<String> getHelpPages() {
        boolean external = false;
        String lang = Cookies.get().get("linqa_lang");
        String helpPath = this.multilingualResourcePath("help/", lang);
        String defaultHelpPath = this.multilingualResourcePath("help/", DEFAULT_HELP_LANG);
        File file = this.getExternalResourceFile(helpPath);
        if (file.exists()) {
            external = true;
        } else {
            file = this.getExternalResourceFile(defaultHelpPath);
            if (file.exists()) {
                external = true;
                lang = DEFAULT_HELP_LANG;
            } else {
                URL resource = this.bundle.getResource(helpPath);
                if (resource == null) {
                    resource = this.bundle.getResource(defaultHelpPath);
                    if (resource != null) {
                        lang = DEFAULT_HELP_LANG;
                    } else {
                        throw new RuntimeException("No help reources found");
                    }
                }
            }
        }
        this.logger.info("Loading help resources, external=" + external + ", lang=" + lang);
        ArrayList<String> texts = new ArrayList<String>();
        int pageNr = 1;
        boolean exists = true;
        String resourcePath = this.multilingualResourcePath("help/page-%d.html", lang);
        do {
            String path = String.format(resourcePath, pageNr++);
            if (external) {
                file = this.getExternalResourceFile(path);
                if (file.exists()) {
                    texts.add(JavaUtils.readTextFile((File)file));
                    continue;
                }
                exists = false;
                continue;
            }
            URL resource = this.bundle.getResource(path);
            if (resource != null) {
                texts.add(JavaUtils.readTextURL((URL)resource));
                continue;
            }
            exists = false;
        } while (exists);
        return texts;
    }

    @Override
    @GET
    @Path(value="/config/{path:.+}")
    @Produces(value={"text/html", "text/css", "image/png"})
    public Response getConfigResource(@PathParam(value="path") String path, @QueryParam(value="multilingual") boolean multilingual, @QueryParam(value="lang") String lang) {
        try {
            File file = this.getExternalResourceFile(multilingual ? this.multilingualResourcePath(path, lang) : path);
            String contentType = JavaUtils.getFileType((String)path);
            if (file.exists()) {
                return Response.ok((Object)new FileInputStream(file)).type(contentType).build();
            }
            String internalResourcePath = this.getInternalResourcePath(path, lang);
            if (internalResourcePath != null) {
                return Response.ok((Object)this.bundle.getResource(internalResourcePath).openStream()).type(contentType).build();
            }
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving config resource \"" + path + "\" failed (multilingual=" + multilingual + ", lang=" + lang + ")", e);
        }
    }

    @Override
    @GET
    @Path(value="/workspaces")
    public List<RelatedTopic> getLinqaWorkspaces() {
        try {
            Topic username = this.acs.getUsernameTopic();
            if (username != null) {
                return this.getLinqaWorkspaces(username);
            }
            return new ArrayList<RelatedTopic>();
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving the user's Linqa workspaces failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/discussion")
    public List<Topic> getDiscussion() {
        try {
            return DMXUtils.loadChildTopics((List)this.ws.getAssignedTopics(this.workspaceId(), "linqa.comment"));
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving the discussion for workspace " + this.workspaceId() + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/users")
    public List<Topic> getAllUsers() {
        try {
            return this.dmx.getTopicsByType("dmx.accesscontrol.username");
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving all Linqa users failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/document")
    @Transactional
    public Topic createDocument(String docName, @QueryParam(value="fileId") long fileId) {
        try {
            TopicModel document = this.createBilingualTopicModel("linqa.document", docName, "_name");
            String lang = document.getChildTopics().getString("linqa.language#linqa.original_language");
            document.getChildTopics().setRef("dmx.files.file#linqa." + this.langSuffix(lang), fileId);
            return this.dmx.createTopic(document);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating document failed, docName=\"" + docName + "\", fileId=" + fileId, e);
        }
    }

    @Override
    @POST
    @Path(value="/note")
    @Transactional
    public Topic createNote(String note) {
        try {
            return this.dmx.createTopic(this.createBilingualTopicModel("linqa.note", note));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating note failed, note=\"" + note + "\"", e);
        }
    }

    @Override
    @POST
    @Path(value="/textblock")
    @Transactional
    public Topic createTextblock(String textblock) {
        try {
            return this.dmx.createTopic(this.createBilingualTopicModel("linqa.textblock", textblock));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating textblock failed, textblock=\"" + textblock + "\"", e);
        }
    }

    @Override
    @POST
    @Path(value="/heading")
    @Transactional
    public Topic createHeading(String heading) {
        try {
            return this.dmx.createTopic(this.createBilingualTopicModel("linqa.heading", heading));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating heading failed, heading=\"" + heading + "\"", e);
        }
    }

    @Override
    @POST
    @Path(value="/comment")
    @Transactional
    public Topic createComment(String comment, @QueryParam(value="refTopicIds") IdList refTopicIds, @QueryParam(value="fileTopicIds") IdList fileTopicIds) {
        try {
            return this._createComment(this.createBilingualTopicModel("linqa.comment", comment), refTopicIds, fileTopicIds);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating comment failed, refTopicIds=" + refTopicIds + ", fileTopicIds=" + fileTopicIds, e);
        }
    }

    @Override
    @POST
    @Path(value="/comment/monolingual")
    @Transactional
    public Topic createMonolingualComment(String comment, @QueryParam(value="refTopicIds") IdList refTopicIds, @QueryParam(value="fileTopicIds") IdList fileTopicIds) {
        try {
            return this._createComment(this.mf.newTopicModel("linqa.comment", this.mf.newChildTopicsModel().set("linqa.comment_text#linqa.lang1", (Object)comment)), refTopicIds, fileTopicIds);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating monolingual comment failed, refTopicIds=" + refTopicIds + ", fileTopicIds=" + fileTopicIds, e);
        }
    }

    @Override
    public Topic createViewport(long workspaceId) {
        try {
            return (Topic)this.dmx.getPrivilegedAccess().runInWorkspaceContext(workspaceId, () -> {
                Topic viewport = this.dmx.createTopic(this.mf.newTopicModel("linqa.viewport", new SimpleValue("Viewport " + this.random.nextLong())));
                ViewProps viewProps = this.mf.newViewProps(0, 0, true, false);
                viewProps.set("dmx.topicmaps.zoom", (Object)1);
                this.tms.addTopicToTopicmap(this.topicmapId(workspaceId), viewport.getId(), viewProps);
                return viewport;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Creating Viewport topic for workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/translate")
    public Translation translate(String text, @QueryParam(value="targetLang") String targetLang) {
        try {
            if (targetLang == null) {
                Translation translation = (Translation)this.deepls.translate(text, DEFAULT_HELP_LANG).get(0);
                String origLang = translation.detectedSourceLang;
                targetLang = this.targetLang(origLang);
            }
            return (Translation)this.deepls.translate(text, targetLang).get(0);
        }
        catch (Exception e) {
            throw new RuntimeException("Translation failed, text=\"" + text + "\", targetLang=" + targetLang, e);
        }
    }

    @Override
    @POST
    @Path(value="/duplicate/{topicIds}")
    @Transactional
    public List<ViewTopic> duplicateMulti(@PathParam(value="topicIds") IdList topicIds, @QueryParam(value="xyOffset") int xyOffset) {
        try {
            long topicmapId = this.topicmapId();
            return this.duplicateTopics(topicIds.stream().map(topicId -> this.dmx.getTopic(topicId.longValue())), topicmapId, topicmapId, xyOffset, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Topic duplication failed, topicIds=" + topicIds + ", xyOffset=" + xyOffset, e);
        }
    }

    @Override
    @PUT
    @Path(value="/locked/{locked}/{topicIds}")
    @Transactional
    public void setLockedMulti(@PathParam(value="locked") boolean locked, @PathParam(value="topicIds") IdList topicIds) {
        topicIds.stream().forEach(topicId -> this.dmx.updateTopic(this.mf.newTopicModel(topicId.longValue(), this.mf.newChildTopicsModel().set("linqa.locked", (Object)locked))));
    }

    @Override
    @PUT
    @Path(value="/user_profile")
    @Transactional
    public void updateUserProfile(@QueryParam(value="displayName") String displayName, @QueryParam(value="showEmailAddress") boolean showEmailAddress, @QueryParam(value="notificationLevel") EmailDigests.NotificationLevel notificationLevel) {
        String username = this.acs.getUsername();
        this.signup.updateDisplayName(username, displayName);
        this.updateShowEmailAddressFacet(username, showEmailAddress);
        EmailDigests.NotificationLevel.set(this.acs.getUsernameTopic(username), notificationLevel);
    }

    @Override
    @POST
    @Path(value="/image")
    @Consumes(value={"multipart/form-data"})
    @Transactional
    public StoredFile storeScaledImage(UploadedFile originalImage) {
        try {
            UploadedFile image;
            UploadedFile scaledImage = new ImageScaler().scale(originalImage);
            if (scaledImage != null) {
                image = scaledImage;
                this.files.storeFile(originalImage, "/");
            } else {
                image = originalImage;
            }
            return this.files.storeFile(image, "/");
        }
        catch (Exception e) {
            throw new RuntimeException("Uploading image " + originalImage + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/admin/workspaces")
    public List<RelatedTopic> getAllLinqaWorkspaces() {
        try {
            return DMXUtils.loadChildTopics((List)this.dmx.getTopicByUri("systems.dmx.linqa").getRelatedTopics("linqa.shared_workspace", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace"));
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving all Linqa workspaces failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/admin/user/{username}/workspaces")
    public List<RelatedTopic> getLinqaWorkspacesOfUser(@PathParam(value="username") String username) {
        try {
            Topic usernameTopic = this.acs.getUsernameTopic(username);
            if (usernameTopic == null) {
                throw new IllegalArgumentException("No such user: \"" + username + "\"");
            }
            List<RelatedTopic> workspaces = this.getLinqaWorkspaces(usernameTopic);
            Assoc membership = this.acs.getMembership(username, this.linqaAdminWs.getId());
            if (membership != null) {
                workspaces.add((RelatedTopic)membership.getDMXObjectByType("dmx.workspaces.workspace").loadChildTopics());
            }
            return workspaces;
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving Linqa workspaces of user \"" + username + "\" failed", e);
        }
    }

    @Override
    public List<RelatedTopic> getLinqaAdmins() {
        return this.acs.getMemberships(this.linqaAdminWs.getId());
    }

    @Override
    @PUT
    @Path(value="/admin/workspace/{workspaceId}")
    @Transactional
    public List<RelatedTopic> bulkUpdateWorkspaceMemberships(@PathParam(value="workspaceId") long workspaceId, @QueryParam(value="addUserIds1") IdList addUserIds1, @QueryParam(value="removeUserIds1") IdList removeUserIds1, @QueryParam(value="addUserIds2") IdList addUserIds2, @QueryParam(value="removeUserIds2") IdList removeUserIds2) {
        try {
            long userId;
            Iterator iterator;
            List users = this.acs.bulkUpdateMemberships(workspaceId, addUserIds1, removeUserIds1);
            if (removeUserIds2 != null) {
                iterator = removeUserIds2.iterator();
                while (iterator.hasNext()) {
                    userId = (Long)iterator.next();
                    this.updateEditorFacet(userId, workspaceId, false);
                }
            }
            if (addUserIds2 != null) {
                iterator = addUserIds2.iterator();
                while (iterator.hasNext()) {
                    userId = (Long)iterator.next();
                    this.updateEditorFacet(userId, workspaceId, true);
                }
            }
            return users;
        }
        catch (Exception e) {
            throw new RuntimeException("Editor role bulk update for Linqa workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    @PUT
    @Path(value="/admin/user/{username}")
    @Transactional
    public List<RelatedTopic> bulkUpdateUserMemberships(@PathParam(value="username") String username, @QueryParam(value="addWorkspaceIds1") IdList addWorkspaceIds1, @QueryParam(value="removeWorkspaceIds1") IdList removeWorkspaceIds1, @QueryParam(value="addWorkspaceIds2") IdList addWorkspaceIds2, @QueryParam(value="removeWorkspaceIds2") IdList removeWorkspaceIds2) {
        try {
            long wsId;
            Iterator iterator;
            this.acs.bulkUpdateMemberships(username, addWorkspaceIds1, removeWorkspaceIds1);
            if (removeWorkspaceIds2 != null) {
                iterator = removeWorkspaceIds2.iterator();
                while (iterator.hasNext()) {
                    wsId = (Long)iterator.next();
                    this.updateEditorFacet(username, wsId, false);
                }
            }
            if (addWorkspaceIds2 != null) {
                iterator = addWorkspaceIds2.iterator();
                while (iterator.hasNext()) {
                    wsId = (Long)iterator.next();
                    this.updateEditorFacet(username, wsId, true);
                }
            }
            return this.getLinqaWorkspacesOfUser(username);
        }
        catch (Exception e) {
            throw new RuntimeException("Editor role bulk update for user \"" + username + "\" failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/admin/user/{emailAddress}/{displayName}/{lang}")
    @Transactional
    public Topic createLinqaUser(@PathParam(value="emailAddress") String emailAddress, @PathParam(value="displayName") String displayName, @PathParam(value="lang") String lang) {
        try {
            Topic usernameTopic = this.signup.createUserAccount(emailAddress, emailAddress, displayName, this.newPassword());
            this.sendWelcomeMail(emailAddress, displayName, lang);
            return usernameTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating Linqa user \"" + displayName + "\" failed, emailAddress=\"" + emailAddress + "\", lang=\"" + lang + "\"", e);
        }
    }

    @Override
    @POST
    @Path(value="/admin/workspace")
    @Transactional
    public Topic createLinqaWorkspace(@QueryParam(value="nameLang1") String nameLang1, @QueryParam(value="nameLang2") String nameLang2) {
        return this.createLinqaWorkspace(nameLang1, nameLang2, true);
    }

    private Topic createLinqaWorkspace(String nameLang1, String nameLang2, boolean createViewport) {
        try {
            Topic workspace = this.ws.createWorkspace(nameLang1, null, SharingMode.COLLABORATIVE);
            workspace.update(this.mf.newChildTopicsModel().set("dmx.workspaces.workspace_name#linqa.lang1", (Object)nameLang1).set("dmx.workspaces.workspace_name#linqa.lang2", (Object)nameLang2));
            long workspaceId = workspace.getId();
            this.dmx.getPrivilegedAccess().runInWorkspaceContext(workspaceId, () -> {
                this.dmx.createAssoc(this.mf.newAssocModel("linqa.shared_workspace", (PlayerModel)this.mf.newTopicPlayerModel("systems.dmx.linqa", "dmx.core.default"), (PlayerModel)this.mf.newTopicPlayerModel(workspaceId, "dmx.core.default")));
                return null;
            });
            if (createViewport) {
                this.createViewport(workspaceId);
            }
            List<RelatedTopic> usernames = this.getLinqaAdmins();
            this.logger.info("### Inviting " + usernames.size() + " Linqa admins to workspace \"" + workspace.getSimpleValue() + "\"");
            this.acs.bulkUpdateMemberships(workspaceId, new IdList(usernames), null);
            return workspace;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating a Linqa workspace failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/admin/workspace/{workspaceId}")
    @Transactional
    public Topic duplicateLinqaWorkspace(@PathParam(value="workspaceId") long workspaceId) {
        try {
            Topic workspace = this.dmx.getTopic(workspaceId);
            ChildTopics children = workspace.getChildTopics();
            String nameLang1 = children.getString("dmx.workspaces.workspace_name#linqa.lang1", "");
            String nameLang2 = children.getString("dmx.workspaces.workspace_name#linqa.lang2", "");
            if (!nameLang1.equals("")) {
                nameLang1 = nameLang1 + " (Copy)";
            }
            if (!nameLang2.equals("")) {
                nameLang2 = nameLang2 + " (Copy)";
            }
            Topic dupWorkspace = this.createLinqaWorkspace(nameLang1, nameLang2, false);
            long dupWorkspaceId = dupWorkspace.getId();
            long srcTopicmapId = this.topicmapId(workspaceId);
            long destTopicmapId = this.topicmapId(dupWorkspaceId);
            this.dmx.getPrivilegedAccess().runInWorkspaceContext(dupWorkspaceId, () -> {
                this.duplicateTopics(this.dmx.getTopic(srcTopicmapId).getRelatedTopics("dmx.topicmaps.topicmap_context", "dmx.core.default", "dmx.topicmaps.topicmap_content", null).stream().filter(this::canvasFilter), srcTopicmapId, destTopicmapId, 0, true);
                return null;
            });
            return dupWorkspace;
        }
        catch (Exception e) {
            throw new RuntimeException("Duplicating workspace " + workspaceId + " failed", e);
        }
    }

    private boolean canvasFilter(Topic topic) {
        return Arrays.asList("linqa.document", "linqa.note", "linqa.textblock", "linqa.heading", "linqa.shape", "linqa.line", "linqa.viewport").contains(topic.getTypeUri());
    }

    private TopicModel createBilingualTopicModel(String topicTypeUri, String text) {
        return this.createBilingualTopicModel(topicTypeUri, text, "_text");
    }

    private TopicModel createBilingualTopicModel(String topicTypeUri, String text, String uriSuffix) {
        Translation translation = this.translate(text, null);
        String origLang = translation.detectedSourceLang;
        return this.mf.newTopicModel(topicTypeUri, this.mf.newChildTopicsModel().set(topicTypeUri + uriSuffix + "#linqa." + this.langSuffix(origLang), (Object)text).set(topicTypeUri + uriSuffix + "#linqa." + this.targetLang(origLang, true), (Object)translation.text).set("linqa.language#linqa.original_language", (Object)origLang));
    }

    private String targetLang(String origLang) {
        return this.targetLang(origLang, false);
    }

    private String targetLang(String origLang, boolean asUriSuffix) {
        if (origLang.equals(CONFIG_LANG1)) {
            return asUriSuffix ? "lang2" : CONFIG_LANG2;
        }
        if (origLang.equals(CONFIG_LANG2)) {
            return asUriSuffix ? "lang1" : CONFIG_LANG1;
        }
        throw new RuntimeException("Unsupported original language: \"" + origLang + "\" (detected)");
    }

    private String langSuffix(String lang) {
        if (lang.equals(CONFIG_LANG1)) {
            return "lang1";
        }
        if (lang.equals(CONFIG_LANG2)) {
            return "lang2";
        }
        throw new RuntimeException("Unsupported language: \"" + lang + "\" (detected)");
    }

    private Topic _createComment(TopicModel commentModel, IdList refTopicIds, IdList fileTopicIds) {
        Iterator iterator;
        if (refTopicIds != null) {
            iterator = refTopicIds.iterator();
            while (iterator.hasNext()) {
                long refTopicId = (Long)iterator.next();
                String compDefUri = this.dmx.getTopic(refTopicId).getTypeUri();
                commentModel.getChildTopics().setRef(compDefUri, refTopicId);
            }
        }
        if (fileTopicIds != null) {
            iterator = fileTopicIds.iterator();
            while (iterator.hasNext()) {
                long fileTopicId = (Long)iterator.next();
                commentModel.getChildTopics().addRef("dmx.files.file#linqa.attachment", fileTopicId);
            }
        }
        Topic comment = this.dmx.createTopic(commentModel);
        this.enrichComment(comment);
        this.timestamps.enrichWithTimestamps((DMXObject)comment);
        this.me.addComment(this.workspaceId(), comment);
        return comment;
    }

    private List<ViewTopic> duplicateTopics(Stream<? extends Topic> topics, long srcTopicmapId, long destTopicmapId, int xyOffset, boolean duplicateLockedState) {
        return topics.map(topic -> {
            long topicId = topic.getId();
            topic.loadChildTopics();
            TopicModel model = topic.getModel();
            model.getChildTopics().remove("dmx.accesscontrol.username#linqa.reaction");
            if (!duplicateLockedState) {
                model.getChildTopics().remove("linqa.locked");
            }
            Topic dupTopic = this.dmx.createTopic(model);
            Assoc assoc = this.tms.getTopicMapcontext(srcTopicmapId, topicId);
            ViewProps viewProps = this.tms.getTopicViewProps(srcTopicmapId, topicId);
            this.fetchLinqaViewProps(topic.getTypeUri(), assoc, viewProps);
            this.enrichWithColor(dupTopic, viewProps);
            viewProps.set("dmx.topicmaps.x", (Object)(viewProps.getInt("dmx.topicmaps.x") + xyOffset));
            viewProps.set("dmx.topicmaps.y", (Object)(viewProps.getInt("dmx.topicmaps.y") + xyOffset));
            this.tms.addTopicToTopicmap(destTopicmapId, dupTopic.getId(), viewProps);
            return this.mf.newViewTopic(dupTopic.getModel(), viewProps);
        }).collect(Collectors.toList());
    }

    private void fetchLinqaViewProps(String topicTypeUri, Assoc assoc, ViewProps viewProps) {
        if (assoc.hasProperty("linqa.color")) {
            viewProps.set("linqa.color", assoc.getProperty("linqa.color"));
        }
        if (assoc.hasProperty("linqa.angle")) {
            viewProps.set("linqa.angle", assoc.getProperty("linqa.angle"));
        }
        if (assoc.hasProperty("linqa.shape_type")) {
            viewProps.set("linqa.shape_type", assoc.getProperty("linqa.shape_type"));
        }
        if (assoc.hasProperty("linqa.arrowheads")) {
            viewProps.set("linqa.arrowheads", assoc.getProperty("linqa.arrowheads"));
        }
        if (assoc.hasProperty("linqa.line_style")) {
            viewProps.set("linqa.line_style", assoc.getProperty("linqa.line_style"));
        }
        if (topicTypeUri.equals("linqa.viewport")) {
            viewProps.set("dmx.topicmaps.zoom", assoc.getProperty("dmx.topicmaps.zoom"));
        }
    }

    private void enrichComment(Topic comment) {
        RelatedTopic refTextblock;
        RelatedTopic refNote;
        this.acs.enrichWithUserInfo((DMXObject)comment);
        ChildTopics children = comment.getChildTopics();
        RelatedTopic refComment = children.getTopicOrNull("linqa.comment");
        if (refComment != null) {
            this.acs.enrichWithUserInfo((DMXObject)refComment);
        }
        if ((refNote = children.getTopicOrNull("linqa.note")) != null) {
            this.enrichWithColor((Topic)refNote);
        }
        if ((refTextblock = children.getTopicOrNull("linqa.textblock")) != null) {
            this.enrichWithColor((Topic)refTextblock);
        }
    }

    private void enrichWithColor(Topic topic) {
        Assoc assoc = this.tms.getTopicMapcontext(this.topicmapId(), topic.getId());
        if (assoc != null && assoc.hasProperty("linqa.color")) {
            topic.getChildTopics().getModel().set("linqa.color", assoc.getProperty("linqa.color"));
        }
    }

    private void enrichWithColor(Topic topic, ViewProps viewProps) {
        String color = viewProps.getString("linqa.color");
        if (color != null) {
            topic.getChildTopics().getModel().set("linqa.color", (Object)color);
        }
    }

    private void enrichWithUsernameProps(Topic username) {
        username.getChildTopics().getModel().set("linqa.notification_level", (Object)EmailDigests.NotificationLevel.getAsString(username));
        if (username.hasProperty("linqa.user_active")) {
            username.getChildTopics().getModel().set("linqa.user_active", username.getProperty("linqa.user_active"));
        }
    }

    private void processLinqaAdminMembership(Assoc assoc, BiConsumer<Topic, String> consumer) {
        Topic workspace;
        if (assoc.getTypeUri().equals("dmx.accesscontrol.membership") && (workspace = (Topic)assoc.getDMXObjectByType("dmx.workspaces.workspace")).getUri().equals("linqa.admin_ws")) {
            Topic usernameTopic = (Topic)assoc.getDMXObjectByType("dmx.accesscontrol.username");
            String username = usernameTopic.getSimpleValue().toString();
            consumer.accept(usernameTopic, username);
        }
    }

    private List<RelatedTopic> getLinqaWorkspaces(Topic username) {
        return DMXUtils.loadChildTopics(username.getRelatedTopics("dmx.accesscontrol.membership", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace").stream().filter(this::isLinqaWorkspace).collect(Collectors.toList()));
    }

    private boolean isLinqaWorkspace(Topic workspace) {
        return this.dmx.getAssocBetweenTopicAndTopic("linqa.shared_workspace", workspace.getId(), this.zwPluginTopic.getId(), "dmx.core.default", "dmx.core.default") != null;
    }

    private long workspaceId() {
        return Cookies.get().getLong("dmx_workspace_id");
    }

    private long topicmapId() {
        return Cookies.get().getLong("dmx_topicmap_id");
    }

    public long topicmapId(long workspaceId) {
        List topicmaps = this.ws.getAssignedTopics(workspaceId, "dmx.topicmaps.topicmap");
        if (topicmaps.size() != 1) {
            throw new RuntimeException("Workspace " + workspaceId + " has " + topicmaps.size() + " topicmaps (expected is 1)");
        }
        return ((Topic)topicmaps.get(0)).getId();
    }

    private void updateEditorFacet(long userId, long workspaceId, boolean editor) throws Exception {
        this.updateEditorFacet(this.getUsername(userId), workspaceId, editor);
    }

    private void updateEditorFacet(String username, long workspaceId, boolean editor) throws Exception {
        this.dmx.getPrivilegedAccess().runInWorkspaceContext(workspaceId, () -> {
            Assoc assoc = this.acs.getMembership(username, workspaceId);
            if (assoc != null) {
                this.facets.updateFacet((DMXObject)assoc, "linqa.editor_facet", this.mf.newFacetValueModel("linqa.editor").set((Object)(workspaceId + ":" + editor)));
            }
            return null;
        });
    }

    private boolean getShowEmailAddress(String username) {
        try {
            Topic usernameTopic = this.acs.getUsernameTopic(username);
            RelatedTopic showEmailAddress = this.facets.getFacet((DMXObject)usernameTopic, "linqa.show_email_address_facet");
            if (showEmailAddress != null) {
                return showEmailAddress.getSimpleValue().booleanValue();
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching \"Show Email Address\" flag of user \"" + username + "\" failed", e);
        }
    }

    private void updateShowEmailAddressFacet(String username, boolean showEmailAddress) {
        try {
            PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
            pa.runInWorkspaceContext(this.getDisplayNamesWorkspaceId(), () -> {
                Topic usernameTopic = this.acs.getUsernameTopic(username);
                if (usernameTopic != null) {
                    this.facets.updateFacet((DMXObject)usernameTopic, "linqa.show_email_address_facet", this.mf.newFacetValueModel("linqa.show_email_address").set((Object)showEmailAddress));
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Updating \"Show Email Address\" flag (" + showEmailAddress + ") of user \"" + username + "\" failed", e);
        }
    }

    private String getUsername(long id) {
        Topic username = this.dmx.getTopic(id);
        String typeUri = username.getTypeUri();
        if (!typeUri.equals("dmx.accesscontrol.username")) {
            throw new IllegalArgumentException("Topic " + id + " is not a Username (but a \"" + typeUri + "\")");
        }
        return username.getSimpleValue().toString();
    }

    private long getDisplayNamesWorkspaceId() {
        return this.dmx.getTopicByUri("dmx.signup.display_names_ws").getId();
    }

    private String newPassword() {
        return new String(Base64.encode((String)Double.toString(Math.random())));
    }

    private void sendWelcomeMail(String emailAddress, String displayName, String lang) {
        try {
            String link = HOST_URL + "/#/password-reset?email=" + emailAddress + "&lang=" + lang;
            String subject = this.sp.getString(lang, "welcome_mail.subject", new Object[0]);
            String message = this.sp.getString(lang, "welcome_mail.message", displayName, link);
            this.sendmail.doEmailRecipient(subject, message, null, emailAddress);
        }
        catch (Exception e) {
            throw new RuntimeException("Sending welcome mail for \"" + displayName + "\" (" + emailAddress + ") failed", e);
        }
    }

    private File getExternalResourceFile(String path) {
        return new File(DMXUtils.getConfigDir() + "dmx-linqa/" + path);
    }

    private String getInternalResourcePath(String path, String lang) {
        String internalPath = null;
        if (path.equals("logo.png") || path.equals("logo-small.png")) {
            internalPath = "web/linqa-logo.png";
        } else if (path.startsWith("help/")) {
            internalPath = path;
        }
        return internalPath;
    }

    private String multilingualResourcePath(String path, String lang) {
        int i = path.indexOf(47);
        if (i == -1 && (i = path.lastIndexOf(46)) == -1) {
            throw new RuntimeException("No file extension recognized in \"" + path + "\"");
        }
        return path.substring(0, i) + "." + lang + path.substring(i);
    }

    private class LinqaStringProvider
    implements StringProvider {
        private LinqaStringProvider() {
        }

        @Override
        public String getString(String lang, String key, Object ... args) {
            try {
                String str = null;
                File f = new File(DMXUtils.getConfigDir() + "dmx-linqa/strings." + lang + ".properties");
                if (f.exists()) {
                    Properties props = new Properties();
                    props.load(new FileReader(f));
                    str = props.getProperty(key);
                }
                if (str == null) {
                    ResourceBundle rb = ResourceBundle.getBundle("app-strings/", new Locale(lang), new UTF8Control());
                    str = rb.getString(key);
                }
                return String.format(str, args);
            }
            catch (Exception e) {
                throw new RuntimeException("Getting \"" + key + "\" resource failed, lang=\"" + lang + "\"");
            }
        }
    }
}

