/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.littlehelpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.jettison.json.JSONArray;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.QueryResult;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.littlehelpers.HelperService;
import systems.dmx.littlehelpers.model.ListTopic;
import systems.dmx.littlehelpers.model.SearchResult;
import systems.dmx.timestamps.TimestampsService;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/littlehelpers")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class HelperPlugin
extends PluginActivator
implements HelperService {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private static final String PROP_URI_CREATED = "dmx.time.created";
    private static final String PROP_URI_MODIFIED = "dmx.time.modified";
    private HashMap<String, TopicType> viewConfigTypeCache = new HashMap();
    private static final String SEARCH_OPTION_CREATED = "created";
    private static final String SEARCH_OPTION_MODIFIED = "modified";
    @Inject
    AccessControlService acService;
    @Inject
    WorkspacesService wsService;
    @Inject
    TimestampsService timeService;

    @Override
    @GET
    @Path(value="/suggest/topics/{input}")
    public List<SearchResult> getSuggestedSearchableUnits(@PathParam(value="input") String query) {
        if (query == null || query.length() < 2) {
            throw new IllegalArgumentException("To receive suggestions, please provide at least two characters.");
        }
        List<Topic> searchResults = this.getTopicSuggestions(query, "dmx.topicmaps.name");
        searchResults.addAll(this.getTopicSuggestions(query, "dmx.notes.title"));
        searchResults.addAll(this.getTopicSuggestions(query, "dmx.accesscontrol.username"));
        QueryResult queryResults = this.dmx.queryTopicsFulltext(query, null, false);
        if (queryResults != null) {
            this.log.info("Fulltext Search for \"" + query + "*\" we found \"" + queryResults.topics.size() + "\" and in Topicmap Name, Notes Title and Username we found \"" + searchResults.size() + "\" topics");
            searchResults.addAll(queryResults.topics);
        }
        List<Topic> newResults = this.findSearchableUnits(searchResults);
        ArrayList<SearchResult> suggestions = new ArrayList<SearchResult>();
        for (Topic t : newResults) {
            SearchResult result = new SearchResult(t, this.wsService.getAssignedWorkspace(t.getId()));
            if (suggestions.contains(result)) continue;
            this.log.fine("Suggesting \"" + t.getSimpleValue() + "\" topics (workspace=" + this.wsService.getAssignedWorkspace(t.getId()) + ")");
            suggestions.add(result);
        }
        this.log.info("Suggesting " + suggestions.size() + " searchable units for input \"" + query + "\"");
        return suggestions;
    }

    @Override
    @GET
    @Path(value="/suggest/topics/{input}/{typeUri}")
    public List<Topic> getTopicSuggestions(@PathParam(value="input") String query, @PathParam(value="typeUri") String typeUri) {
        return this.dmx.queryTopicsFulltext((String)query, (String)typeUri, (boolean)false).topics;
    }

    @Override
    @GET
    @Path(value="/by_time/{time_value}/{since}/{to}")
    @Produces(value={"application/json"})
    public List<ListTopic> getStandardTopicsInTimeRange(@PathParam(value="time_value") String type, @PathParam(value="since") long since, @PathParam(value="to") long to) {
        ArrayList<ListTopic> results = new ArrayList<ListTopic>();
        try {
            this.log.info("Fetching Standard Topics (\"" + type + "\") since: " + new Date(since) + " and " + new Date(to));
            ArrayList<Topic> standardTopics = new ArrayList<Topic>();
            Collection<Topic> overallTopics = this.fetchAllTopicsInTimerange(type, since, to);
            if (overallTopics.isEmpty()) {
                this.log.info("getStandardTopicsInTimeRange(" + type + ") got NO result.");
            }
            for (Topic in_question : overallTopics) {
                if (!in_question.getTypeUri().equals("dmx.notes.note") && !in_question.getTypeUri().equals("dmx.files.file") && !in_question.getTypeUri().equals("dmx.files.folder") && !in_question.getTypeUri().equals("dmx.contacts.person") && !in_question.getTypeUri().equals("dmx.contacts.organization") && !in_question.getTypeUri().equals("dmx.bookmarks.bookmark")) continue;
                standardTopics.add(in_question);
            }
            this.log.info("Topics " + type + " in timerange query found " + standardTopics.size() + " standard topics");
            List<? extends Topic> in_memory_resources = null;
            if (type.equals(SEARCH_OPTION_CREATED)) {
                in_memory_resources = this.getTopicListSortedByCreationTime(standardTopics);
            } else if (type.equals(SEARCH_OPTION_MODIFIED)) {
                in_memory_resources = this.getTopicListSortedByModificationTime(standardTopics);
            }
            for (Topic topic : in_memory_resources) {
                try {
                    topic.loadChildTopics();
                    ListTopic viewTopic = this.prepareViewTopicItem(topic);
                    results.add(viewTopic);
                }
                catch (RuntimeException rex) {
                    this.log.warning("Could not add fetched item to results, caused by: " + rex.getMessage());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("something went wrong", e);
        }
        return results;
    }

    @Override
    @GET
    @Path(value="/timeindex/{time_value}/{since}/{to}")
    @Produces(value={"application/json"})
    public String getTopicIndexForTimeRange(@PathParam(value="time_value") String type, @PathParam(value="since") long since, @PathParam(value="to") long to) {
        JSONArray results = new JSONArray();
        try {
            this.log.info("Populating Topic Index (\"" + type + "\") since: " + new Date(since) + " and " + new Date(to));
            ArrayList<Topic> standardTopics = new ArrayList<Topic>();
            Collection<Topic> overallTopics = this.fetchAllTopicsInTimerange(type, since, to);
            for (Topic in_question : overallTopics) {
                if (!in_question.getTypeUri().equals("dmx.notes.note") && !in_question.getTypeUri().equals("dmx.files.file") && !in_question.getTypeUri().equals("dmx.files.folder") && !in_question.getTypeUri().equals("dmx.contacts.person") && !in_question.getTypeUri().equals("dmx.contacts.organization") && !in_question.getTypeUri().equals("dmx.bookmarks.bookmark")) continue;
                standardTopics.add(in_question);
            }
            this.log.info(type + " Topic Index for timerange query found " + standardTopics.size() + " standard topics (" + overallTopics.size() + " overall)");
            for (Topic item : standardTopics) {
                this.enrichTopicModelAboutCreationTimestamp(item);
                this.enrichTopicModelAboutModificationTimestamp(item);
                results.put((Object)item.toJSON());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("something went wrong", e);
        }
        return results.toString();
    }

    @Override
    public List<? extends Topic> getTopicListSortedByCreationTime(List<? extends Topic> all) {
        Collections.sort(all, new Comparator<Topic>(){

            @Override
            public int compare(Topic t1, Topic t2) {
                try {
                    Object one = t1.getProperty(HelperPlugin.PROP_URI_CREATED);
                    Object two = t2.getProperty(HelperPlugin.PROP_URI_CREATED);
                    if (Long.parseLong(one.toString()) < Long.parseLong(two.toString())) {
                        return 1;
                    }
                    if (Long.parseLong(one.toString()) > Long.parseLong(two.toString())) {
                        return -1;
                    }
                }
                catch (Exception nfe) {
                    HelperPlugin.this.log.warning("Error while accessing timestamp of Topic 1: " + t1.getId() + " Topic2: " + t2.getId() + " nfe: " + nfe.getMessage());
                    return 0;
                }
                return 0;
            }
        });
        return all;
    }

    @Override
    public List<? extends Topic> getTopicListSortedByModificationTime(List<? extends Topic> all) {
        Collections.sort(all, new Comparator<Topic>(){

            @Override
            public int compare(Topic t1, Topic t2) {
                try {
                    Object one = t1.getProperty(HelperPlugin.PROP_URI_MODIFIED);
                    Object two = t2.getProperty(HelperPlugin.PROP_URI_MODIFIED);
                    if (Long.parseLong(one.toString()) < Long.parseLong(two.toString())) {
                        return 1;
                    }
                    if (Long.parseLong(one.toString()) > Long.parseLong(two.toString())) {
                        return -1;
                    }
                }
                catch (Exception nfe) {
                    HelperPlugin.this.log.warning("Error while accessing timestamp of Topic 1: " + t1.getId() + " Topic2: " + t2.getId() + " nfe: " + nfe.getMessage());
                    return 0;
                }
                return 0;
            }
        });
        return all;
    }

    @Override
    public void sortCompareToBySimpleValue(List<? extends Topic> topics) {
        Collections.sort(topics, new Comparator<Topic>(){

            @Override
            public int compare(Topic t1, Topic t2) {
                String one = t1.getSimpleValue().toString();
                String two = t2.getSimpleValue().toString();
                return one.compareTo(two);
            }
        });
    }

    @Override
    public void sortCompareToByChildTypeValue(List<? extends Topic> topics, final String childTypeUri) {
        Collections.sort(topics, new Comparator<Topic>(){

            @Override
            public int compare(Topic t1, Topic t2) {
                t1.loadChildTopics(childTypeUri);
                t2.loadChildTopics(childTypeUri);
                String one = t1.getChildTopics().getString(childTypeUri);
                String two = t2.getChildTopics().getString(childTypeUri);
                return one.compareTo(two);
            }
        });
    }

    @Override
    public void enrichTopicModelAboutIconConfigURL(Topic element) {
        TopicType topicType = null;
        if (this.viewConfigTypeCache.containsKey(element.getTypeUri())) {
            topicType = this.viewConfigTypeCache.get(element.getTypeUri());
        } else {
            topicType = this.dmx.getTopicType(element.getTypeUri());
            this.viewConfigTypeCache.put(element.getTypeUri(), topicType);
        }
        Object iconUrl = this.getViewConfig(topicType, "icon");
        if (iconUrl != null) {
            ChildTopicsModel resourceModel = element.getChildTopics().getModel();
            resourceModel.set("dmx.webclient.icon", (Object)iconUrl.toString());
        }
    }

    @Override
    public void enrichTopicModelAboutCreationTimestamp(Topic resource) {
        long created = this.timeService.getCreationTime(resource.getId());
        ChildTopicsModel resourceModel = resource.getChildTopics().getModel();
        resourceModel.set(PROP_URI_CREATED, (Object)created);
    }

    @Override
    public void enrichTopicModelAboutModificationTimestamp(Topic resource) {
        long created = this.timeService.getModificationTime(resource.getId());
        ChildTopicsModel resourceModel = resource.getChildTopics().getModel();
        resourceModel.set(PROP_URI_MODIFIED, (Object)created);
    }

    @Override
    public List<Topic> findSearchableUnits(List<? extends Topic> topics) {
        ArrayList<Topic> searchableUnits = new ArrayList<Topic>();
        for (Topic topic : topics) {
            if (this.searchableAsUnit(topic)) {
                searchableUnits.add(topic);
                continue;
            }
            List parentTopics = topic.getRelatedTopics(null, "dmx.core.child", "dmx.core.parent", null);
            if (parentTopics.isEmpty()) {
                searchableUnits.add(topic);
                continue;
            }
            searchableUnits.addAll(this.findSearchableUnits(parentTopics));
        }
        return searchableUnits;
    }

    private boolean searchableAsUnit(Topic topic) {
        TopicType topicType = this.dmx.getTopicType(topic.getTypeUri());
        Boolean searchableAsUnit = (Boolean)this.getViewConfig(topicType, "searchable_as_unit");
        return searchableAsUnit != null ? searchableAsUnit : false;
    }

    private Collection<Topic> fetchAllTopicsInTimerange(String searchOption, long since, long to) {
        Collection topics = null;
        if (searchOption.equals(SEARCH_OPTION_CREATED)) {
            topics = this.timeService.getTopicsByCreationTime(since, to);
            this.log.fine("> Queried " + topics.size() + " elements CREATED since: " + new Date(since) + " and " + new Date(to));
        } else if (searchOption.equals(SEARCH_OPTION_MODIFIED)) {
            topics = this.timeService.getTopicsByModificationTime(since, to);
            this.log.fine("> Queried " + topics.size() + " elements MODIFIED since: " + new Date(since) + " and " + new Date(to));
        } else {
            throw new RuntimeException("Invalid search parameter: set time_value either to \"created\" or \"modified\"");
        }
        return topics;
    }

    private Object getViewConfig(TopicType topicType, String setting) {
        return topicType.getViewConfigValue("dmx.webclient.view_config", "dmx.webclient." + setting);
    }

    private ListTopic prepareViewTopicItem(Topic item) {
        this.enrichTopicModelAboutCreationTimestamp(item);
        this.enrichTopicModelAboutModificationTimestamp(item);
        this.enrichTopicModelAboutIconConfigURL(item);
        ListTopic viewTopic = new ListTopic(item, this.acService, this.wsService);
        return viewTopic;
    }
}

