/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.littlehelpers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONArray;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.Assoc;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.TopicResult;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.littlehelpers.HelperService;
import systems.dmx.littlehelpers.model.ListTopic;
import systems.dmx.littlehelpers.model.SearchResult;
import systems.dmx.timestamps.TimestampsService;
import systems.dmx.topicmaps.TopicmapsService;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/littlehelpers")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class HelperPlugin
extends PluginActivator
implements HelperService {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private static final String WEBCLIENT_ICON_URI = "dmx.webclient.icon";
    public static final String WEBCLIENT_SLUG = "/systems.dmx.webclient/#";
    private HashMap<String, TopicType> viewConfigTypeCache = new HashMap();
    private static final String SEARCH_OPTION_CREATED = "created";
    private static final String SEARCH_OPTION_MODIFIED = "modified";
    @Inject
    AccessControlService acl;
    @Inject
    WorkspacesService workspaces;
    @Inject
    TimestampsService timestamps;
    @Inject
    TopicmapsService topicmaps;

    @Override
    public List<TopicType> getTopicTypesConfiguredForCreateMenu() {
        List allTypes = this.dmx.getAllTopicTypes();
        ArrayList<TopicType> result = new ArrayList<TopicType>();
        for (TopicType type : allTypes) {
            if (!this.getViewConfig(type, "add_to_create_menu").equals(true)) continue;
            result.add(type);
        }
        return result;
    }

    @Override
    public List<Topic> getTopicmapsByMaptype(String mapTypeUri) {
        List allMaps = this.dmx.getTopicsByType("dmx.topicmaps.topicmap");
        ArrayList<Topic> result = new ArrayList<Topic>();
        for (Topic t : allMaps) {
            String topicmapType = t.getChildTopics().getString("dmx.topicmaps.topicmap_type_uri");
            if (!mapTypeUri.equals(topicmapType)) continue;
            result.add(t);
        }
        return result;
    }

    @Override
    public Topic getWorkspaceByName(String name) {
        RelatedTopic realWs = null;
        Topic ws = this.dmx.getTopicByValue("dmx.workspaces.workspace_name", new SimpleValue(name));
        if (ws == null) {
            List existingWs = this.dmx.getTopicsByType("dmx.workspaces.workspace");
            for (Topic topic : existingWs) {
                if (!topic.getSimpleValue().toString().equals(name)) continue;
                return topic;
            }
        } else {
            realWs = ws.getRelatedTopic(null, "dmx.core.child", "dmx.core.parent", "dmx.workspaces.workspace");
            return realWs;
        }
        return realWs;
    }

    @GET
    @Path(value="/open-in-map/{topicmapId}/{topicId}")
    @Produces(value={"text/html"})
    @Transactional
    public Response showTopicInTopicmap(@PathParam(value="topicmapId") long topicmapId, @PathParam(value="topicId") long topicId) throws URISyntaxException {
        Topic map;
        if (topicmapId != -1L && (map = this.dmx.getTopic(topicmapId)).getTypeUri().equals("dmx.topicmaps.topicmap")) {
            this.setTopicPositionInBrowserViewport(topicmapId, topicId);
            return Response.seeOther((URI)new URI("/systems.dmx.webclient/#/topicmap/" + topicmapId + "/topic/" + topicId)).build();
        }
        return Response.seeOther((URI)new URI("/systems.dmx.webclient/#/topicmap/" + topicmapId)).build();
    }

    @Transactional
    private void setTopicPositionInBrowserViewport(long topicmapId, long topicId) {
        Topic topicmap = this.dmx.getTopic(topicmapId);
        double zoom = (Double)topicmap.getProperty("dmx.topicmaps.zoom");
        Assoc tc = this.topicmaps.getTopicMapcontext(topicmapId, topicId);
        if (tc == null) {
            int mapX = (Integer)topicmap.getProperty("dmx.topicmaps.pan_x");
            int mapY = (Integer)topicmap.getProperty("dmx.topicmaps.pan_y");
            this.topicmaps.addTopicToTopicmap(topicmap.getId(), topicId, mapX + 300, mapY + 300, true);
        } else {
            int x = (Integer)tc.getProperty("dmx.topicmaps.x");
            int y = (Integer)tc.getProperty("dmx.topicmaps.y");
            boolean visibility = (Boolean)tc.getProperty("dmx.topicmaps.visibility");
            if (!visibility) {
                tc.setProperty("dmx.topicmaps.visibility", (Object)true, false);
            }
            if (this.acl.getUsername() != null) {
                this.topicmaps.setTopicmapViewport(topicmapId, 300 - x, 200 - y, zoom);
            }
        }
    }

    @GET
    @Path(value="/topicmaps/{mapTypeUri}")
    @Produces(value={"application/json"})
    @Transactional
    public String getTopicmaps(@PathParam(value="mapTypeUri") String mapTypeUri) throws URISyntaxException {
        return DMXUtils.toJSONArray(this.getTopicmapsByMaptype(mapTypeUri)).toString();
    }

    @Override
    public ChildTopicsModel setDateTopic(ChildTopicsModel cm, Date date, String assocTypeUri) {
        ChildTopicsModel child = this.mf.newChildTopicsModel();
        child.set("dmx.datetime.day", (Object)date.getDate());
        child.set("dmx.datetime.month", (Object)(date.getMonth() + 1));
        child.set("dmx.datetime.year", (Object)(date.getYear() + 1900));
        cm.set("dmx.datetime.date#" + assocTypeUri, this.mf.newTopicModel("dmx.datetime.date", child));
        return cm;
    }

    public List<Topic> applyTopicmapFilter(List<Topic> searchResults, long topicmapId) {
        ArrayList<Topic> filteredResults = new ArrayList<Topic>();
        if (topicmapId > 0L && !searchResults.isEmpty()) {
            this.log.info("> Filter list of " + searchResults.size() + " uniqueResults about topicmap: " + topicmapId);
            for (Topic searchResult : searchResults) {
                if (!this.isTopicVisibleInTopicmap(topicmapId, searchResult.getId())) continue;
                filteredResults.add(searchResult);
            }
        }
        return filteredResults;
    }

    public boolean isTopicVisibleInTopicmap(long topicmapId, long topicId) {
        Assoc mapContext = this.topicmaps.getTopicMapcontext(topicmapId, topicId);
        return mapContext == null ? false : (Boolean)mapContext.getProperty("dmx.topicmaps.visibility");
    }

    @Override
    @GET
    @Path(value="/suggest/topics/{input}")
    public List<SearchResult> getSuggestedSearchResults(@PathParam(value="input") String query) {
        if (query == null || query.length() < 2) {
            throw new IllegalArgumentException("To receive suggestions, please provide at least two characters.");
        }
        List<Topic> searchResults = this.getTopicSuggestions(query, "dmx.topicmaps.name");
        searchResults.addAll(this.getTopicSuggestions(query, "dmx.notes.title"));
        searchResults.addAll(this.getTopicSuggestions(query, "dmx.accesscontrol.username"));
        TopicResult queryResults = this.dmx.queryTopicsFulltext(query, null, false);
        if (queryResults != null) {
            this.log.info("Fulltext Search for \"" + query + "\" we found \"" + queryResults.topics.size() + "\" and in Topicmap Name, Notes Title and Username we found \"" + searchResults.size() + "\" topics");
            searchResults.addAll(queryResults.topics);
        }
        ArrayList<SearchResult> suggestions = new ArrayList<SearchResult>();
        for (Topic t : searchResults) {
            SearchResult result = new SearchResult(t, this.workspaces.getAssignedWorkspace(t.getId()));
            if (suggestions.contains(result)) continue;
            this.log.fine("Suggesting \"" + t.getSimpleValue() + "\" topics (workspace=" + this.workspaces.getAssignedWorkspace(t.getId()) + ")");
            suggestions.add(result);
        }
        this.log.info("Suggesting " + suggestions.size() + " search results for input \"" + query + "\"");
        return suggestions;
    }

    @Override
    @GET
    @Path(value="/suggest/topics/{input}/{typeUri}")
    public List<Topic> getTopicSuggestions(@PathParam(value="input") String query, @PathParam(value="typeUri") String typeUri) {
        return this.dmx.queryTopicsFulltext((String)query, (String)typeUri, (boolean)false).topics;
    }

    @Override
    @GET
    @Path(value="/by_time/{time_value}/{since}/{to}")
    @Produces(value={"application/json"})
    public List<ListTopic> getTopicsInTimeRange(@PathParam(value="time_value") String type, @PathParam(value="since") long since, @PathParam(value="to") long to) {
        ArrayList<ListTopic> results = new ArrayList<ListTopic>();
        try {
            this.log.info("Fetching Standard Topics (\"" + type + "\") since: " + new Date(since) + " and " + new Date(to));
            ArrayList<Topic> standardTopics = new ArrayList<Topic>();
            Collection<Topic> overallTopics = this.fetchAllTopicsInTimerange(type, since, to);
            if (overallTopics.isEmpty()) {
                this.log.info("getStandardTopicsInTimeRange(" + type + ") got NO result.");
            }
            for (Topic in_question : overallTopics) {
                if (!in_question.getTypeUri().equals("dmx.notes.note") && !in_question.getTypeUri().equals("dmx.files.file") && !in_question.getTypeUri().equals("dmx.files.folder") && !in_question.getTypeUri().equals("dmx.contacts.person") && !in_question.getTypeUri().equals("dmx.contacts.organization") && !in_question.getTypeUri().equals("dmx.bookmarks.bookmark")) continue;
                standardTopics.add(in_question);
            }
            this.log.info("Topics " + type + " in timerange query found " + standardTopics.size() + " standard topics");
            List<? extends Topic> in_memory_resources = null;
            if (type.equals(SEARCH_OPTION_CREATED)) {
                in_memory_resources = this.getTopicsDescendingByCreationTime(standardTopics);
            } else if (type.equals(SEARCH_OPTION_MODIFIED)) {
                in_memory_resources = this.getTopicsDescendingByModificationTime(standardTopics);
            }
            for (Topic topic : in_memory_resources) {
                try {
                    topic.loadChildTopics();
                    ListTopic viewTopic = this.buildListTopic(topic);
                    results.add(viewTopic);
                }
                catch (RuntimeException rex) {
                    this.log.warning("Could not add fetched item to results, caused by: " + rex.getMessage());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("something went wrong", e);
        }
        return results;
    }

    @Override
    @GET
    @Path(value="/timeindex/{time_value}/{since}/{to}")
    @Produces(value={"application/json"})
    public String getIndexForTimeRange(@PathParam(value="time_value") String type, @PathParam(value="since") long since, @PathParam(value="to") long to) {
        JSONArray results = new JSONArray();
        try {
            this.log.info("Populating Topic Index (\"" + type + "\") since: " + new Date(since) + " and " + new Date(to));
            ArrayList<Topic> standardTopics = new ArrayList<Topic>();
            Collection<Topic> overallTopics = this.fetchAllTopicsInTimerange(type, since, to);
            for (Topic in_question : overallTopics) {
                if (!in_question.getTypeUri().equals("dmx.notes.note") && !in_question.getTypeUri().equals("dmx.files.file") && !in_question.getTypeUri().equals("dmx.files.folder") && !in_question.getTypeUri().equals("dmx.contacts.person") && !in_question.getTypeUri().equals("dmx.contacts.organization") && !in_question.getTypeUri().equals("dmx.bookmarks.bookmark")) continue;
                standardTopics.add(in_question);
            }
            this.log.info(type + " Topic Index for timerange query found " + standardTopics.size() + " standard topics (" + overallTopics.size() + " overall)");
            for (Topic item : standardTopics) {
                this.enrichTopicModelAboutCreationTimestamp(item);
                this.enrichTopicModelAboutModificationTimestamp(item);
                results.put((Object)item.toJSON());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("something went wrong", e);
        }
        return results.toString();
    }

    @Override
    public List<? extends Topic> getTopicsDescendingByCreationTime(List<? extends Topic> all) {
        Collections.sort(all, new Comparator<Topic>(){

            @Override
            public int compare(Topic t1, Topic t2) {
                try {
                    Object one = t1.getProperty("dmx.timestamps.created");
                    Object two = t2.getProperty("dmx.timestamps.created");
                    if (Long.parseLong(one.toString()) < Long.parseLong(two.toString())) {
                        return 1;
                    }
                    if (Long.parseLong(one.toString()) > Long.parseLong(two.toString())) {
                        return -1;
                    }
                }
                catch (Exception nfe) {
                    HelperPlugin.this.log.warning("Error while accessing timestamp of Topic 1: " + t1.getId() + " Topic2: " + t2.getId() + " nfe: " + nfe.getMessage());
                    return 0;
                }
                return 0;
            }
        });
        return all;
    }

    @Override
    public List<? extends Topic> getTopicsDescendingByModificationTime(List<? extends Topic> all) {
        Collections.sort(all, new Comparator<Topic>(){

            @Override
            public int compare(Topic t1, Topic t2) {
                try {
                    Object one = t1.getProperty("dmx.timestamps.modified");
                    Object two = t2.getProperty("dmx.timestamps.modified");
                    if (Long.parseLong(one.toString()) < Long.parseLong(two.toString())) {
                        return 1;
                    }
                    if (Long.parseLong(one.toString()) > Long.parseLong(two.toString())) {
                        return -1;
                    }
                }
                catch (Exception nfe) {
                    HelperPlugin.this.log.warning("Error while accessing timestamp of Topic 1: " + t1.getId() + " Topic2: " + t2.getId() + " nfe: " + nfe.getMessage());
                    return 0;
                }
                return 0;
            }
        });
        return all;
    }

    @Override
    public void compareToBySimpleValue(List<? extends Topic> topics) {
        Collections.sort(topics, new Comparator<Topic>(){

            @Override
            public int compare(Topic t1, Topic t2) {
                String one = t1.getSimpleValue().toString();
                String two = t2.getSimpleValue().toString();
                return one.compareTo(two);
            }
        });
    }

    @Override
    public void compareToByChildTypeValue(List<? extends Topic> topics, final String childTypeUri) {
        Collections.sort(topics, new Comparator<Topic>(){

            @Override
            public int compare(Topic t1, Topic t2) {
                t1.loadChildTopics(childTypeUri);
                t2.loadChildTopics(childTypeUri);
                String one = t1.getChildTopics().getString(childTypeUri);
                String two = t2.getChildTopics().getString(childTypeUri);
                return one.compareTo(two);
            }
        });
    }

    @Override
    public void enrichTopicModelAboutIconConfigURL(Topic element) {
        TopicType topicType = null;
        if (this.viewConfigTypeCache.containsKey(element.getTypeUri())) {
            topicType = this.viewConfigTypeCache.get(element.getTypeUri());
        } else {
            topicType = this.dmx.getTopicType(element.getTypeUri());
            this.viewConfigTypeCache.put(element.getTypeUri(), topicType);
        }
        Object iconUrl = this.getViewConfig(topicType, "icon");
        if (iconUrl != null) {
            ChildTopicsModel resourceModel = element.getChildTopics().getModel();
            resourceModel.set(WEBCLIENT_ICON_URI, (Object)iconUrl.toString());
        }
    }

    @Override
    public void enrichTopicModelAboutCreationTimestamp(Topic resource) {
        long created = this.timestamps.getCreationTime(resource.getId());
        ChildTopicsModel resourceModel = resource.getChildTopics().getModel();
        resourceModel.set("dmx.timestamps.created", (Object)created);
    }

    @Override
    public void enrichTopicModelAboutModificationTimestamp(Topic resource) {
        long created = this.timestamps.getModificationTime(resource.getId());
        ChildTopicsModel resourceModel = resource.getChildTopics().getModel();
        resourceModel.set("dmx.timestamps.modified", (Object)created);
    }

    private Collection<Topic> fetchAllTopicsInTimerange(String searchOption, long since, long to) {
        Collection topics = null;
        if (searchOption.equals(SEARCH_OPTION_CREATED)) {
            topics = this.timestamps.getTopicsByCreationTime(since, to);
            this.log.fine("> Queried " + topics.size() + " elements CREATED since: " + new Date(since) + " and " + new Date(to));
        } else if (searchOption.equals(SEARCH_OPTION_MODIFIED)) {
            topics = this.timestamps.getTopicsByModificationTime(since, to);
            this.log.fine("> Queried " + topics.size() + " elements MODIFIED since: " + new Date(since) + " and " + new Date(to));
        } else {
            throw new RuntimeException("Invalid search parameter: set time_value either to \"created\" or \"modified\"");
        }
        return topics;
    }

    private Object getViewConfig(TopicType topicType, String setting) {
        return topicType.getViewConfigValue("dmx.webclient.view_config", "dmx.webclient." + setting);
    }

    private ListTopic buildListTopic(Topic item) {
        this.enrichTopicModelAboutCreationTimestamp(item);
        this.enrichTopicModelAboutModificationTimestamp(item);
        this.enrichTopicModelAboutIconConfigURL(item);
        ListTopic viewTopic = new ListTopic(item, this.acl, this.workspaces);
        return viewTopic;
    }
}

