/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.littlehelpers.model;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.Topic;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.workspaces.WorkspacesService;

public final class ListTopic
implements JSONEnabled {
    JSONObject topic = new JSONObject();

    public ListTopic(Topic item, AccessControlService ac, WorkspacesService ws) {
        this.topic = item.toJSON();
        this.setUsername(ac.getCreator(item.getId()));
        this.setWorkspace(ws.getAssignedWorkspace(item.getId()));
    }

    public void includeTags(Topic item) {
        List tags = item.getRelatedTopics(null, null, null, "dmx.tags.tag");
        if (tags != null) {
            try {
                this.topic.put("tags", (Object)DMXUtils.toJSONArray((Iterable)tags));
            }
            catch (JSONException ex) {
                Logger.getLogger(ListTopic.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setUsername(String username) {
        try {
            this.topic.put("creator", (Object)username);
        }
        catch (JSONException ex) {
            Logger.getLogger(ListTopic.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setWorkspace(Topic workspace) {
        try {
            this.topic.put("workspace", (Object)workspace.getSimpleValue().toString());
            this.topic.put("workspace_id", workspace.getId());
        }
        catch (JSONException ex) {
            Logger.getLogger(ListTopic.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public JSONObject toJSON() {
        return this.topic;
    }
}

