/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav.chunk;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.wav.chunk.WavInfoIdentifier;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.wav.WavInfoTag;
import org.jaudiotagger.tag.wav.WavTag;

public class WavInfoChunk {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.wav.WavInfoChunk");
    private WavInfoTag wavInfoTag = new WavInfoTag();

    public WavInfoChunk(WavTag tag) {
        tag.setInfoTag(this.wavInfoTag);
    }

    public boolean readChunks(ByteBuffer chunkData) {
        while (chunkData.hasRemaining()) {
            String id = Utils.readFourBytesAsChars(chunkData);
            int size = chunkData.getInt();
            String value = Utils.getString(chunkData, 0, size, StandardCharsets.UTF_8);
            logger.config("Result:" + id + ":" + size + ":" + value + ":");
            WavInfoIdentifier wii = WavInfoIdentifier.getByCode(id);
            if (wii != null && wii.getFieldKey() != null) {
                try {
                    this.wavInfoTag.setField(wii.getFieldKey(), value);
                }
                catch (FieldDataInvalidException fdie) {
                    fdie.printStackTrace();
                }
            } else if (id != null && !id.trim().isEmpty()) {
                this.wavInfoTag.addUnRecognizedField(id, value);
            }
            if ((size & 1) == 0 || !chunkData.hasRemaining()) continue;
            chunkData.get();
        }
        return true;
    }
}

