/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.ContainerType;
import org.jaudiotagger.audio.asf.data.MetadataContainer;
import org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import org.jaudiotagger.audio.asf.util.Utils;

public final class ContentDescription
extends MetadataContainer {
    public static final Set<String> ALLOWED = new HashSet<String>(Arrays.asList("AUTHOR", "COPYRIGHT", "DESCRIPTION", "RATING", "TITLE"));
    public static final String KEY_AUTHOR = "AUTHOR";
    public static final String KEY_COPYRIGHT = "COPYRIGHT";
    public static final String KEY_DESCRIPTION = "DESCRIPTION";
    public static final String KEY_RATING = "RATING";
    public static final String KEY_TITLE = "TITLE";

    public ContentDescription() {
        this(0L, BigInteger.ZERO);
    }

    public ContentDescription(long pos, BigInteger chunkLen) {
        super(ContainerType.CONTENT_DESCRIPTION, pos, chunkLen);
    }

    public String getAuthor() {
        return this.getValueFor(KEY_AUTHOR);
    }

    public String getComment() {
        return this.getValueFor(KEY_DESCRIPTION);
    }

    public String getCopyRight() {
        return this.getValueFor(KEY_COPYRIGHT);
    }

    @Override
    public long getCurrentAsfChunkSize() {
        long result = 44L;
        result += (long)(this.getAuthor().length() * 2);
        result += (long)(this.getComment().length() * 2);
        result += (long)(this.getRating().length() * 2);
        result += (long)(this.getTitle().length() * 2);
        return result += (long)(this.getCopyRight().length() * 2);
    }

    public String getRating() {
        return this.getValueFor(KEY_RATING);
    }

    public String getTitle() {
        return this.getValueFor(KEY_TITLE);
    }

    @Override
    public boolean isAddSupported(MetadataDescriptor descriptor) {
        return ALLOWED.contains(descriptor.getName()) && super.isAddSupported(descriptor);
    }

    @Override
    public String prettyPrint(String prefix) {
        StringBuilder result = new StringBuilder(super.prettyPrint(prefix));
        result.append(prefix).append("  |->Title      : ").append(this.getTitle()).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("  |->Author     : ").append(this.getAuthor()).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("  |->Copyright  : ").append(this.getCopyRight()).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("  |->Description: ").append(this.getComment()).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("  |->Rating     :").append(this.getRating()).append(Utils.LINE_SEPARATOR);
        return result.toString();
    }

    public void setAuthor(String fileAuthor) throws IllegalArgumentException {
        this.setStringValue(KEY_AUTHOR, fileAuthor);
    }

    public void setComment(String tagComment) throws IllegalArgumentException {
        this.setStringValue(KEY_DESCRIPTION, tagComment);
    }

    public void setCopyright(String cpright) throws IllegalArgumentException {
        this.setStringValue(KEY_COPYRIGHT, cpright);
    }

    public void setRating(String ratingText) throws IllegalArgumentException {
        this.setStringValue(KEY_RATING, ratingText);
    }

    public void setTitle(String songTitle) throws IllegalArgumentException {
        this.setStringValue(KEY_TITLE, songTitle);
    }

    @Override
    public long writeInto(OutputStream out) throws IOException {
        long chunkSize = this.getCurrentAsfChunkSize();
        out.write(this.getGuid().getBytes());
        Utils.writeUINT64(this.getCurrentAsfChunkSize(), out);
        Utils.writeUINT16(this.getTitle().length() * 2 + 2, out);
        Utils.writeUINT16(this.getAuthor().length() * 2 + 2, out);
        Utils.writeUINT16(this.getCopyRight().length() * 2 + 2, out);
        Utils.writeUINT16(this.getComment().length() * 2 + 2, out);
        Utils.writeUINT16(this.getRating().length() * 2 + 2, out);
        out.write(Utils.getBytes(this.getTitle(), AsfHeader.ASF_CHARSET));
        out.write(AsfHeader.ZERO_TERM);
        out.write(Utils.getBytes(this.getAuthor(), AsfHeader.ASF_CHARSET));
        out.write(AsfHeader.ZERO_TERM);
        out.write(Utils.getBytes(this.getCopyRight(), AsfHeader.ASF_CHARSET));
        out.write(AsfHeader.ZERO_TERM);
        out.write(Utils.getBytes(this.getComment(), AsfHeader.ASF_CHARSET));
        out.write(AsfHeader.ZERO_TERM);
        out.write(Utils.getBytes(this.getRating(), AsfHeader.ASF_CHARSET));
        out.write(AsfHeader.ZERO_TERM);
        return chunkSize;
    }
}

