/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class FileTypeUtil {
    private static final int BUFFER_SIZE = 4096;
    private static final int MAX_SIGNATURE_SIZE = 8;
    private static final Integer[] mp3v2Sig = new Integer[]{73, 68, 51};
    private static final Integer[] mp3v1Sig = new Integer[]{255, 251};
    private static final Integer[] mp4Sig = new Integer[]{0, 0, 0, null, 102, 116, 121, 112};
    private static Map<String, Integer[]> signatureMap = new HashMap<String, Integer[]>();
    private static Map<String, String> extensionMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMagicFileType(File f) throws IOException {
        byte[] buffer = new byte[4096];
        try (FileInputStream in = new FileInputStream(f);){
            int m;
            int n;
            for (m = n = ((InputStream)in).read(buffer, 0, 4096); m < 8 && n > 0; m += n) {
                n = ((InputStream)in).read(buffer, m, 4096 - m);
            }
            String fileType = "UNKNOWN";
            for (String key : signatureMap.keySet()) {
                if (!FileTypeUtil.matchesSignature(signatureMap.get(key), buffer, m)) continue;
                fileType = key;
                break;
            }
            String string = fileType;
            return string;
        }
    }

    public static String getMagicExt(String fileType) {
        return extensionMap.get(fileType);
    }

    private static boolean matchesSignature(Integer[] signature, byte[] buffer, int size) {
        if (size < signature.length) {
            return false;
        }
        boolean b = true;
        for (int i = 0; i < signature.length; ++i) {
            if (signature[i] == null || signature[i] == (0xFF & buffer[i])) continue;
            b = false;
            break;
        }
        return b;
    }

    public static void main(String[] args) throws IOException {
        String testFileLoc = "C:/Users/keerthi/Dropbox/Works/Java/github/GaanaExtractor/workspace/jaudiotagger/testm4a";
        String fileType = FileTypeUtil.getMagicFileType(new File(testFileLoc));
        System.out.println("File type: " + fileType);
        System.out.println("File Extension: " + FileTypeUtil.getMagicExt(fileType));
    }

    static {
        signatureMap.put("MP3IDv2", mp3v2Sig);
        signatureMap.put("MP3IDv1", mp3v1Sig);
        signatureMap.put("MP4", mp4Sig);
        extensionMap = new HashMap<String, String>();
        extensionMap.put("MP3IDv2", "mp3");
        extensionMap.put("MP3IDv1", "mp3");
        extensionMap.put("MP4", "m4a");
        extensionMap.put("UNKNOWN", "");
    }
}

