/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.music;

import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import systems.dmx.core.Topic;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.util.ChildTopicsSequence;
import systems.dmx.files.FilesService;
import systems.dmx.music.MusicService;
import systems.dmx.music.TagReader;
import systems.dmx.music.Tags;

@Path(value="/music")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MusicPlugin
extends PluginActivator
implements MusicService {
    @Inject
    private FilesService fs;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @PUT
    @Path(value="/playlist/{playlistId}/file/{fileId}")
    @Transactional
    public void addFileToPlaylist(@PathParam(value="fileId") long fileId, @PathParam(value="playlistId") long playlistId) {
        try {
            Tags tags = TagReader.read(this.fs.getFile(fileId));
            this.logger.info("Adding file " + fileId + " to playlist " + playlistId + ", tags: " + tags);
            Topic playlist = this.dmx.getTopic(playlistId);
            Topic track = this.dmx.createTopic(this.mf.newTopicModel("dmx.music.track", this.mf.newChildTopicsModel().set("dmx.music.track_title", (Object)tags.title).set("dmx.music.artist", (Object)tags.artist).set("dmx.music.album", (Object)tags.album).set("dmx.datetime.year", (Object)tags.year).setRef("dmx.files.file", fileId)));
            playlist.update(this.mf.newChildTopicsModel().addRef("dmx.music.track#dmx.music.playlist_item", track.getId()));
            ChildTopicsSequence s = new ChildTopicsSequence(playlist, "dmx.music.track", "dmx.music.playlist_item", this.dmx);
            s.insert(track.getId(), -1L);
        }
        catch (Exception e) {
            throw new RuntimeException("Adding file " + fileId + " to playlist " + playlistId + " failed", e);
        }
    }
}

