/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.notifications;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.DMXType;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.event.PostCreateAssoc;
import systems.dmx.core.service.event.PostCreateTopic;
import systems.dmx.core.service.event.PostUpdateTopic;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.notifications.NotificationsService;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/notifications")
public class NotificationsPlugin
extends PluginActivator
implements NotificationsService,
PostUpdateTopic,
PostCreateTopic,
PostCreateAssoc {
    private static Logger log = Logger.getLogger(NotificationsPlugin.class.getName());
    private static final String NOTIFICATON_BUNDLE_URI = "systems.dmx.notifications";
    @Inject
    private AccessControlService accesscontrol = null;
    @Inject
    private WorkspacesService workspaces = null;

    public void postCreateTopic(Topic topic) {
        if (this.isAuthenticatedUser()) {
            if (topic.getTypeUri().equals("dmx.topicmaps.topicmap")) {
                long workspaceId = this.dmx.getPrivilegedAccess().getAssignedWorkspaceId(topic.getId());
                this.notifyWorkspaceSubscribersAboutNewTopicmap(topic, workspaceId);
            } else if (topic.getTypeUri().equals("dmx.events.event")) {
                long workspaceId = this.dmx.getPrivilegedAccess().getAssignedWorkspaceId(topic.getId());
                this.notifyWorkspaceSubscribersAboutNewEvent(topic, workspaceId);
            } else if (topic.getTypeUri().equals("dmx.notes.note")) {
                long workspaceId = this.dmx.getPrivilegedAccess().getAssignedWorkspaceId(topic.getId());
                this.notifyWorkspaceSubscribersAboutNewNote(topic, workspaceId);
            }
        }
    }

    public void postUpdateTopic(Topic topic, TopicModel tm, TopicModel tm1) {
        if (topic.getTypeUri().equals("dmx.notes.text")) {
            this.notifyTopicSubscribersAboutChangeset(topic, tm, tm1);
        }
    }

    public void postCreateAssoc(Assoc association) {
        if (this.isAuthenticatedUser() && association.getTypeUri().equals("dmx.topicmaps.topicmap_context")) {
            this.notifyTopicmapSubscribersAboutNewTopicInMap(association);
        }
    }

    @POST
    @Path(value="/subscribe/{itemId}")
    @Transactional
    public Response subscribeUser(@PathParam(value="itemId") long itemId) {
        if (this.isAuthenticatedUser()) {
            this.subscribeInApp(itemId);
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="/unsubscribe/{itemId}")
    @Transactional
    public Response unsubscribeUser(@PathParam(value="itemId") long itemId) {
        if (this.isAuthenticatedUser()) {
            this.unsubscribe(itemId);
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @Override
    @GET
    @Path(value="/subscription")
    public List<RelatedTopic> getSubscriptions() {
        if (this.isAuthenticatedUser()) {
            Topic account = this.accesscontrol.getUsernameTopic();
            log.fine("Listing subscriptions for user \"" + account.getSimpleValue() + "\"");
            return account.getRelatedTopics("dmx.notification_subscription_edge", null, null, null);
        }
        return null;
    }

    @GET
    @Path(value="/subscription/{itemId}")
    public String getSubscription(@PathParam(value="itemId") long itemId) {
        if (this.isAuthenticatedUser()) {
            Topic account = this.accesscontrol.getUsernameTopic();
            log.info("Checking subscription for user \"" + account.getSimpleValue() + "\" on item " + itemId);
            return "" + this.associationExists("dmx.notification_subscription_edge", itemId, account.getId());
        }
        return "false";
    }

    @GET
    @Path(value="/notification")
    public List<RelatedTopic> getNotificationsForUser() {
        return this.getNotifications();
    }

    @GET
    @Path(value="/notification/unseen")
    public ArrayList<RelatedTopic> getUnseenNotificationsForUser() {
        return this.getUnseenNotifications();
    }

    @GET
    @Path(value="/notification/seen/{newsId}")
    @Transactional
    public Response setNotificationSeen(@PathParam(value="newsId") long newsId) {
        try {
            if (this.isAuthenticatedUser()) {
                log.warning("Nobody logged in for whom we could set the notification as seen.");
                return Response.ok((Object)false).build();
            }
            Topic notification = (Topic)this.dmx.getTopic(newsId).loadChildTopics();
            notification.update(notification.getChildTopics().getModel().set("dmx.notification_seen", (Object)true));
            log.fine("Set notification " + newsId + " SEEN");
            return Response.ok((Object)true).build();
        }
        catch (Exception e) {
            log.warning("Could NOT set notification " + newsId + " SEEN, Caused by: " + e.getCause().toString() + ", " + e.getMessage());
            return Response.ok((Object)false).build();
        }
    }

    @Override
    public void subscribeInApp(long itemId) {
        if (!this.isAuthenticatedUser()) {
            throw new RuntimeException("For users to manage their subscriptions they must be authenticated.");
        }
        Topic account = this.accesscontrol.getUsernameTopic();
        this.subscribeInApp(account.getId(), itemId);
    }

    @Override
    public void unsubscribe(long itemId) {
        if (!this.isAuthenticatedUser()) {
            throw new RuntimeException("For users to manage their subscriptions they must be authenticated.");
        }
        Topic account = this.accesscontrol.getUsernameTopic();
        this.unsubscribe(account.getId(), itemId);
    }

    @Override
    @Transactional
    public void notifySubscribers(String title, String message, long actingUsername, DMXObject involvedItem) {
        log.info("Notifying subscribers for action involving \"" + involvedItem.getSimpleValue() + "\" (" + involvedItem.getType().getSimpleValue() + ")");
        this.createNotifications(title, message, actingUsername, involvedItem);
        List tags = null;
        try {
            tags = involvedItem.getChildTopics().getTopicsOrNull("dmx.tags.tag");
        }
        catch (RuntimeException rex) {
            log.fine("Skipping expected RuntimeException ... " + rex.getMessage());
        }
        if (tags != null) {
            for (RelatedTopic tag : tags) {
                log.info("Notifying subscribers of tag \"" + tag.getSimpleValue() + "\"");
                this.createNotifications(title, message, actingUsername, involvedItem, (DMXObject)tag);
            }
        }
        this.dmx.getWebSocketService().sendToAll("Please reload notifications area for the user.");
    }

    @Override
    public List<RelatedTopic> getNotifications() {
        if (!this.isAuthenticatedUser()) {
            throw new RuntimeException("For users to read their notifications they must be authenticated.");
        }
        Topic account = this.accesscontrol.getUsernameTopic();
        List results = account.getRelatedTopics("dmx.notification_recipient_edge", "dmx.core.default", "dmx.core.default", "dmx.notification");
        log.fine("Fetching " + results.size() + " notifications for user " + account.getSimpleValue());
        DMXUtils.loadChildTopics((List)results);
        return results;
    }

    public ArrayList<RelatedTopic> getUnseenNotifications() {
        if (!this.isAuthenticatedUser()) {
            throw new RuntimeException("For users to read their notifications they must be authenticated.");
        }
        Topic account = this.accesscontrol.getUsernameTopic();
        ArrayList<RelatedTopic> unseen = new ArrayList<RelatedTopic>();
        List results = account.getRelatedTopics("dmx.notification_recipient_edge", "dmx.core.default", "dmx.core.default", "dmx.notification");
        for (RelatedTopic notification : results) {
            boolean seen_child = notification.getChildTopics().getBoolean("dmx.notification_seen");
            if (seen_child) continue;
            unseen.add(notification);
        }
        log.info("Fetching " + unseen.size() + " unseen notifications for user " + account.getSimpleValue());
        return unseen;
    }

    @Transactional
    private void subscribeInApp(long accountId, long itemId) {
        try {
            if (!this.associationExists("dmx.notification_subscription_edge", itemId, accountId)) {
                AssocModel model = this.mf.newAssocModel("dmx.notification_subscription_edge", (PlayerModel)this.mf.newTopicPlayerModel(accountId, "dmx.core.default"), (PlayerModel)this.mf.newTopicPlayerModel(itemId, "dmx.core.default"), this.mf.newChildTopicsModel().addRef("dmx.subscription_type", "dmx.in_app_subscription"));
                this.dmx.createAssoc(model);
                log.info("New subscription for user:" + accountId + " to item:" + itemId);
            } else {
                log.info("Subscription already exists between " + accountId + " and " + itemId);
            }
        }
        catch (Exception e) {
            log.warning("ROLLBACK!");
            log.warning("Subscription between " + accountId + " and " + itemId + " not created.");
            throw new RuntimeException(e);
        }
    }

    @Transactional
    private void unsubscribe(long accountId, long itemId) {
        List assocs = this.dmx.getAssocs(accountId, itemId, "dmx.notification_subscription_edge");
        for (Assoc assoc : assocs) {
            this.dmx.deleteAssoc(assoc.getId());
        }
    }

    private void notifyTopicSubscribersAboutChangeset(Topic childValueTopicEdited, TopicModel tm1, TopicModel tm2) {
        Topic actingUsername = this.accesscontrol.getUsernameTopic();
        List parentTopics = childValueTopicEdited.getRelatedTopics("dmx.core.composition", "dmx.core.child", "dmx.core.parent", null);
        if (parentTopics.size() > 0) {
            RelatedTopic subscribedItem = (RelatedTopic)parentTopics.get(0);
            this.notifySubscribers("Topic \"" + subscribedItem.getSimpleValue() + "\" edited by user \"" + actingUsername.getSimpleValue() + "\"", "<p>As a subscriber of topic \"" + subscribedItem.getSimpleValue() + "\" you receive this automatic notification about the update of " + childValueTopicEdited.getType().getSimpleValue() + " by <em>" + actingUsername.getSimpleValue() + "</em>.</p><h3>" + subscribedItem.getType().getSimpleValue() + " Before</h3><p>" + tm2.getSimpleValue() + "</p><h3>" + subscribedItem.getType().getSimpleValue() + " After</h3><p>" + tm1.getSimpleValue() + "</p>", actingUsername.getId(), (DMXObject)subscribedItem);
        }
    }

    private void notifyWorkspaceSubscribersAboutNewEvent(Topic event, long workspaceId) {
        Topic actingUsername = this.accesscontrol.getUsernameTopic();
        if (event.getTypeUri().equals("dmx.events.event") && workspaceId != -1L) {
            Topic workspace = this.dmx.getTopic(workspaceId);
            log.info("Notifying subscribers about new event created by \"" + actingUsername.getSimpleValue() + "\" in workspace \"" + workspace.getSimpleValue() + "\"");
            this.notifySubscribers("Event \"" + event.getSimpleValue() + "\" created in Workspace \"" + workspace.getSimpleValue() + "\"", "A new event was created by \"" + actingUsername.getSimpleValue() + "\" in workspace \"" + workspace.getSimpleValue() + "\"", actingUsername.getId(), (DMXObject)workspace);
        }
    }

    private void notifyWorkspaceSubscribersAboutNewNote(Topic note, long workspaceId) {
        Topic actingUsername = this.accesscontrol.getUsernameTopic();
        if (note.getTypeUri().equals("dmx.notes.note") && workspaceId != -1L) {
            Topic workspace = this.dmx.getTopic(workspaceId);
            log.info("Notifying subscribers about new note created by \"" + actingUsername.getSimpleValue() + "\" in workspace \"" + workspace.getSimpleValue() + "\"");
            this.notifySubscribers("Note \"" + note.getSimpleValue() + "\" created in Workspace \"" + workspace.getSimpleValue() + "\"", "A new note was created by \"" + actingUsername.getSimpleValue() + "\" in workspace \"" + workspace.getSimpleValue() + "\"", actingUsername.getId(), (DMXObject)workspace);
        }
    }

    private void notifyWorkspaceSubscribersAboutNewTopicmap(Topic topicmap, long workspaceId) {
        Topic actingUsername = this.accesscontrol.getUsernameTopic();
        if (topicmap.getTypeUri().equals("dmx.topicmaps.topicmap") && workspaceId != -1L) {
            Topic workspace = this.dmx.getTopic(workspaceId);
            topicmap.loadChildTopics();
            log.info("Topicmap in creation " + topicmap.toJSON().toString());
            Topic map2 = this.dmx.getTopic(topicmap.getId());
            log.info("Topicmap in storage " + map2.toJSON().toString());
            log.info("Notifying subscribers about new topicmap created by \"" + actingUsername.getSimpleValue() + "\" in workspace \"" + workspace.getSimpleValue() + "\"");
            this.notifySubscribers("Topicmap \"" + topicmap.getSimpleValue() + "\" created in Workspace \"" + workspace.getSimpleValue() + "\"", "A new topicmap was created by \"" + actingUsername.getSimpleValue() + "\" in workspace \"" + workspace.getSimpleValue() + "\"", actingUsername.getId(), (DMXObject)workspace);
        }
    }

    private void notifyTopicmapSubscribersAboutNewTopicInMap(Assoc association) {
        Topic actingUser = this.accesscontrol.getUsernameTopic();
        DMXObject topic = null;
        DMXObject topicmap = null;
        if (association.getDMXObject1().getTypeUri().equals("dmx.topicmaps.topicmap")) {
            topic = association.getDMXObject2();
            topicmap = association.getDMXObject1();
            log.fine("Added Topic of type \"" + topic.getTypeUri() + "\" to Topicmap \"" + topicmap.getSimpleValue() + "\"");
        } else {
            topic = association.getDMXObject1();
            topicmap = association.getDMXObject2();
            log.fine("Added Topic of type \"" + topic.getTypeUri() + "\" to Topicmap \"" + topicmap.getSimpleValue() + "\"");
        }
        DMXType type = topic.getType();
        if (!topic.getTypeUri().equals("dmx.notification")) {
            this.notifySubscribers(type.getSimpleValue() + " added to Topicmap \"" + topicmap.getSimpleValue() + "\"", "An entry on " + (topic.getSimpleValue().toString().isEmpty() ? "..." : topic.getSimpleValue()) + " was added to Topicmap \"" + topicmap.getSimpleValue() + "\"", actingUser.getId(), topicmap);
        }
    }

    private boolean isAuthenticatedUser() {
        String username = this.accesscontrol.getUsername();
        return username != null && !username.isEmpty();
    }

    private void createNotifications(String title, String text, long actingUsername, DMXObject involvedItem) {
        this.createNotifications(title, text, actingUsername, involvedItem, null);
    }

    private void createNotifications(String title, String text, long actingUsername, DMXObject involvedItem, DMXObject subscribedItem) {
        List subscribers = null;
        subscribers = subscribedItem != null ? subscribedItem.getRelatedTopics("dmx.notification_subscription_edge", "dmx.core.default", "dmx.core.default", "dmx.accesscontrol.username") : involvedItem.getRelatedTopics("dmx.notification_subscription_edge", "dmx.core.default", "dmx.core.default", "dmx.accesscontrol.username");
        for (RelatedTopic subscriber : subscribers) {
            if (subscriber.getId() == actingUsername) continue;
            log.info("Identified subscription, notifying user " + subscriber.getSimpleValue());
            this.createNotificationTopic((Topic)subscriber, title, text, actingUsername, involvedItem, subscribedItem);
        }
    }

    private void createNotificationTopic(final Topic subscriber, final String title, final String text, final long actingUsername, final DMXObject involvedItem, final DMXObject subscribedItem) {
        try {
            this.dmx.getPrivilegedAccess().runWithoutWorkspaceAssignment((Callable)new Callable<Topic>(){

                @Override
                public Topic call() {
                    ChildTopicsModel message = NotificationsPlugin.this.mf.newChildTopicsModel().set("dmx.notification_seen", (Object)false).set("dmx.notification_title", (Object)title).set("dmx.notification_body", (Object)text).setRef("dmx.accesscontrol.username", actingUsername).set("dmx.involved_item_id", (Object)involvedItem.getId());
                    if (subscribedItem != null) {
                        message.set("dmx.subscribed_item_id", (Object)subscribedItem.getId());
                    }
                    TopicModel model = NotificationsPlugin.this.mf.newTopicModel("dmx.notification", message);
                    Topic notification = NotificationsPlugin.this.dmx.createTopic(model);
                    Topic privateWorkspace = NotificationsPlugin.this.dmx.getPrivilegedAccess().getPrivateWorkspace(subscriber.getSimpleValue().toString());
                    NotificationsPlugin.this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)notification, privateWorkspace.getId());
                    NotificationsPlugin.this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)notification.getChildTopics().getTopic("dmx.notification_title"), privateWorkspace.getId());
                    NotificationsPlugin.this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)notification.getChildTopics().getTopic("dmx.notification_body"), privateWorkspace.getId());
                    NotificationsPlugin.this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)notification.getChildTopics().getTopic("dmx.notification_seen"), privateWorkspace.getId());
                    NotificationsPlugin.this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)notification.getChildTopics().getTopic("dmx.involved_item_id"), privateWorkspace.getId());
                    if (subscribedItem != null) {
                        NotificationsPlugin.this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)notification.getChildTopics().getTopic("dmx.subscribed_item_id"), privateWorkspace.getId());
                    }
                    AssocModel recipientModel = NotificationsPlugin.this.mf.newAssocModel("dmx.notification_recipient_edge", model.createPlayerModel("dmx.core.default"), (PlayerModel)NotificationsPlugin.this.mf.newTopicPlayerModel(subscriber.getId(), "dmx.core.default"));
                    Assoc recipient = NotificationsPlugin.this.dmx.createAssoc(recipientModel);
                    NotificationsPlugin.this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)recipient, privateWorkspace.getId());
                    return notification;
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException("Creating notification for user " + subscriber.getSimpleValue() + " failed", ex);
        }
    }

    private boolean associationExists(String edge_type, long itemId, long accountId) {
        List results = this.dmx.getAssocs(itemId, accountId, edge_type);
        return results.size() > 0;
    }
}

