/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.manager;

import com.nimbusds.oauth2.sdk.ParseException;
import java.io.IOException;
import java.net.URISyntaxException;
import systems.dmx.accountmanagement.AccountManager;
import systems.dmx.accountmanagement.CheckCredentialsResult;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.oidc.manager.PasswordGrantFlow;

public class OidcAccountManager
implements AccountManager {
    public static final String NAME = "OIDC";
    private final PasswordGrantFlow passwordGrantFlow;

    public OidcAccountManager() {
        PasswordGrantFlow passwordGrantFlow1;
        try {
            passwordGrantFlow1 = new PasswordGrantFlow(new PasswordGrantFlow.Configuration("endpoint", "client id", "client secret"));
        }
        catch (URISyntaxException e) {
            passwordGrantFlow1 = null;
            System.err.println("Unable to create password grant flow: " + e.getLocalizedMessage());
        }
        this.passwordGrantFlow = passwordGrantFlow1;
    }

    public String name() {
        return NAME;
    }

    public void createAccount(Credentials credentials) {
        throw new RuntimeException("Not supported");
    }

    public void changePassword(Credentials credentials, Credentials credentials1) {
        throw new RuntimeException("Not supported");
    }

    public void onUsernameDeleted(String s) {
    }

    public CheckCredentialsResult checkCredentials(Credentials credentials) {
        try {
            return this.passwordGrantFlow.login(credentials.username, credentials.password) ? CheckCredentialsResult.lookupOrCreationRequired() : CheckCredentialsResult.failed();
        }
        catch (ParseException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

