/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.Path;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.accountmanagement.AccountManagementService;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.oidc.OidcService;
import systems.dmx.oidc.configuration.Configuration;
import systems.dmx.oidc.di.DaggerOidcComponent;
import systems.dmx.oidc.di.OidcComponent;
import systems.dmx.oidc.manager.OidcAccountManager;
import systems.dmx.oidc.usecase.CreateOidcAccountManagerUseCase;

@Path(value="/oidc")
public class OidcPlugin
extends PluginActivator
implements OidcService {
    @Inject
    private AccessControlService accessControlService;
    @Inject
    private AccountManagementService accountManagementService;
    private Configuration configuration;
    private List<OidcAccountManager> accountManagerList = Collections.emptyList();

    public void serviceArrived(Object service) {
    }

    public void serviceGone(Object service) {
        if (service instanceof AccountManagementService) {
            this.accountManagerList.forEach(arg_0 -> ((AccountManagementService)this.accountManagementService).unregisterAccountManager(arg_0));
        }
    }

    public void init() {
        OidcComponent component = DaggerOidcComponent.builder().accessControlService(this.accessControlService).coreService(this.dmx).accountManagementService(this.accountManagementService).build();
        this.configuration = component.configuration();
        CreateOidcAccountManagerUseCase createOidcAccountManagerUseCase = component.createOidcAccountManagerUseCase();
        this.accountManagerList = this.configuration.providerConfigurations.stream().map(createOidcAccountManagerUseCase::invoke).filter(Objects::nonNull).collect(Collectors.toList());
        this.accountManagerList.forEach(arg_0 -> ((AccountManagementService)this.accountManagementService).registerAccountManager(arg_0));
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }
}

