/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.configuration;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import systems.dmx.oidc.configuration.AdministrationType;
import systems.dmx.oidc.configuration.Configuration;
import systems.dmx.oidc.configuration.ConfigurationDatasource;
import systems.dmx.oidc.configuration.FlowType;
import systems.dmx.oidc.configuration.Identifier;

public class ConfigurationRepository {
    private final ConfigurationDatasource datasource;

    @Inject
    ConfigurationRepository(ConfigurationDatasource datasource) {
        this.datasource = datasource;
    }

    public Configuration parseConfiguration() {
        List<String> providerIds = this.datasource.getStringList(Identifier.PROVIDERS.key);
        List<Configuration.ProviderConfiguration> providerConfigurations = providerIds.stream().map(this::parseProviderConfiguration).filter(Objects::nonNull).collect(Collectors.toList());
        return new Configuration(providerConfigurations);
    }

    @Nullable
    private Configuration.ProviderConfiguration parseProviderConfiguration(String providerId) {
        FlowType flowType = FlowType.fromStringOrPasswordGrant(this.datasource.getString(Identifier.FLOW_TYPE.getKey(providerId), Identifier.FLOW_TYPE.defaultValue));
        String tokenEndpoint = this.datasource.getString(Identifier.TOKEN_ENDPOINT.getKey(providerId), Identifier.TOKEN_ENDPOINT.defaultValue);
        String clientId = this.datasource.getString(Identifier.CLIENT_ID.getKey(providerId), Identifier.CLIENT_ID.defaultValue);
        String clientSecret = this.datasource.getString(Identifier.CLIENT_SECRET.getKey(providerId), Identifier.CLIENT_SECRET.defaultValue);
        AdministrationType administrationType = AdministrationType.fromStringOrNone(this.datasource.getString(Identifier.ADMINISTRATION_TYPE.getKey(providerId), Identifier.TOKEN_ENDPOINT.defaultValue));
        return tokenEndpoint != null && clientId != null && clientSecret != null ? new Configuration.ProviderConfiguration(providerId, flowType, tokenEndpoint, clientId, clientSecret, administrationType) : null;
    }
}

