/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.usecase;

import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import systems.dmx.oidc.configuration.Configuration;

public class LogConfigurationUseCase {
    private static final Logger logger = Logger.getLogger(LogConfigurationUseCase.class.getName());

    @Inject
    LogConfigurationUseCase() {
    }

    public void invoke(Configuration configuration) {
        logger.info("DMX OIDC Plugin Configuration:");
        List providerIds = configuration.providerConfigurations.stream().map(it -> it.id).collect(Collectors.toList());
        logger.info(String.format("Configured identity providers: %s", providerIds));
        configuration.providerConfigurations.forEach(this::logProviderConfiguration);
    }

    private void logProviderConfiguration(Configuration.ProviderConfiguration providerConfiguration) {
        logger.info(String.format("\nProvider Id: %s", providerConfiguration.id));
        logger.info(String.format("Flow Type: %s\t\t", new Object[]{providerConfiguration.flowType}));
        logger.info(String.format("Token Endpoint: %s\t", providerConfiguration.id));
        logger.info(String.format("Client Id: %s\t\t", providerConfiguration.clientId));
        logger.info(String.format("Client Secret: %s\t", providerConfiguration.clientSecret));
        logger.info(String.format("Administration Type: %s", new Object[]{providerConfiguration.administrationType}));
    }
}

