/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.configuration;

import systems.dmx.oidc.configuration.AdministrationType;
import systems.dmx.oidc.configuration.FlowType;

enum Identifier {
    PROVIDERS("systems.dmx.oidc.providers", ""),
    FLOW_TYPE("systems.dmx.oidc.provider[{providerId}].flow-type", FlowType.PASSWORD_GRANT.name()),
    TOKEN_ENDPOINT("systems.dmx.oidc.provider[{providerId}].token-endpoint", null),
    CLIENT_ID("systems.dmx.oidc.provider[{providerId}].client-id", null),
    CLIENT_SECRET("systems.dmx.oidc.provider[{providerId}].client-secret", null),
    ADMINISTRATION_TYPE("systems.dmx.oidc.provider[{providerId}].administration-type", AdministrationType.NONE.name());

    public final String key;
    public final String defaultValue;

    private Identifier(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    String getKey(String providerId) {
        return this.key.replace("{providerId}", providerId);
    }
}

