/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.manager;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import systems.dmx.oidc.configuration.Configuration;

public class PasswordGrantFlow {
    private final URI tokenEndpoint;
    private final ClientID clientID;
    private final Secret clientSecret;

    public PasswordGrantFlow(Configuration.ProviderConfiguration providerConfiguration) throws URISyntaxException {
        this.tokenEndpoint = new URI(providerConfiguration.tokenEndpoint);
        this.clientID = new ClientID(providerConfiguration.clientId);
        this.clientSecret = new Secret(providerConfiguration.clientSecret);
    }

    public boolean login(String username, String password) throws IOException, ParseException {
        ClientSecretBasic clientAuth = new ClientSecretBasic(this.clientID, this.clientSecret);
        ResourceOwnerPasswordCredentialsGrant passwordGrant = new ResourceOwnerPasswordCredentialsGrant(username, new Secret(password));
        TokenRequest request = new TokenRequest(this.tokenEndpoint, (ClientAuthentication)clientAuth, (AuthorizationGrant)passwordGrant, null);
        TokenResponse response = TokenResponse.parse((HTTPResponse)request.toHTTPRequest().send());
        if (response.indicatesSuccess()) {
            AccessTokenResponse successResponse = (AccessTokenResponse)response;
            AccessToken accessToken = successResponse.getTokens().getAccessToken();
            RefreshToken refreshToken = successResponse.getTokens().getRefreshToken();
            System.out.println("Access Token: " + accessToken.getValue());
            System.out.println("Refresh Token: " + (refreshToken != null ? refreshToken.getValue() : "Kein Refresh Token"));
            return true;
        }
        TokenErrorResponse errorResponse = response.toErrorResponse();
        System.out.println("Fehler: " + errorResponse.getErrorObject().getDescription());
        return false;
    }
}

