/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.accountmanagement.AccountManagementService;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.oidc.OidcService;
import systems.dmx.oidc.configuration.Configuration;
import systems.dmx.oidc.di.DaggerOidcComponent;
import systems.dmx.oidc.di.OidcComponent;
import systems.dmx.oidc.manager.OidcAccountManager;
import systems.dmx.oidc.usecase.CreateOidcAccountManagerUseCase;
import systems.dmx.oidc.usecase.HandleOAuthCallbackUseCase;
import systems.dmx.oidc.usecase.LogConfigurationUseCase;

@Path(value="/oidc")
public class OidcPlugin
extends PluginActivator
implements OidcService {
    private static final Logger logger = Logger.getLogger(OidcPlugin.class.getName());
    @Inject
    private AccessControlService accessControlService;
    @Inject
    private AccountManagementService accountManagementService;
    @Context
    private HttpServletRequest request;
    private Configuration configuration;
    HandleOAuthCallbackUseCase handleOAuthCallbackUseCase;
    private List<OidcAccountManager> accountManagerList = Collections.emptyList();

    public void serviceArrived(Object service) {
    }

    public void serviceGone(Object service) {
        if (service instanceof AccountManagementService) {
            this.accountManagerList.forEach(arg_0 -> ((AccountManagementService)this.accountManagementService).unregisterAccountManager(arg_0));
        }
    }

    public void init() {
        OidcComponent component = DaggerOidcComponent.builder().accessControlService(this.accessControlService).coreService(this.dmx).accountManagementService(this.accountManagementService).build();
        this.configuration = component.configuration();
        this.handleOAuthCallbackUseCase = component.handleOAuthCallbackUseCase();
        LogConfigurationUseCase logConfigurationUseCase = component.logConfigurationUseCase();
        logConfigurationUseCase.invoke(this.configuration);
        CreateOidcAccountManagerUseCase createOidcAccountManagerUseCase = component.createOidcAccountManagerUseCase();
        this.accountManagerList = this.configuration.providerConfigurations.stream().map(providerConfiguration -> createOidcAccountManagerUseCase.invoke(this.configuration, (Configuration.ProviderConfiguration)providerConfiguration)).filter(Objects::nonNull).collect(Collectors.toList());
        this.accountManagerList.forEach(arg_0 -> ((AccountManagementService)this.accountManagementService).registerAccountManager(arg_0));
        this.accountManagerList.forEach(oidcAccountManager -> {
            if (oidcAccountManager.canProvideAuthRequestUri()) {
                logger.info("log in using this URI: " + oidcAccountManager.newAuthRequestUri());
            }
        });
    }

    @GET
    @Path(value="/callback")
    public void callback(@QueryParam(value="code") String authorizationCode, @QueryParam(value="state") String state) {
        this.handleOAuthCallbackUseCase.invoke(this.request, authorizationCode, state);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }
}

