/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.configuration;

import systems.dmx.oidc.configuration.AdministrationType;

enum Identifier {
    DMX_HOST_URL("dmx.host.url", null),
    PROVIDERS("systems.dmx.oidc.providers", ""),
    AUTHORIZATION_ENDPOINT("systems.dmx.oidc.provider[{providerId}].authorization-endpoint", ""),
    TOKEN_ENDPOINT("systems.dmx.oidc.provider[{providerId}].token-endpoint", ""),
    CLIENT_ID("systems.dmx.oidc.provider[{providerId}].client-id", null),
    CLIENT_SECRET("systems.dmx.oidc.provider[{providerId}].client-secret", null),
    ADMINISTRATION_TYPE("systems.dmx.oidc.provider[{providerId}].administration-type", AdministrationType.NONE.name());

    public final String key;
    public final String defaultValue;

    private Identifier(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    String getKey(String providerId) {
        return this.key.replace("{providerId}", providerId);
    }
}

