/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.di;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import javax.inject.Provider;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.accountmanagement.AccountManagementService;
import systems.dmx.core.service.CoreService;
import systems.dmx.oidc.configuration.Configuration;
import systems.dmx.oidc.configuration.ConfigurationDatasource;
import systems.dmx.oidc.configuration.ConfigurationRepository;
import systems.dmx.oidc.configuration.ConfigurationRepository_Factory;
import systems.dmx.oidc.configuration.SystemPropertyConfigurationDatasource_Factory;
import systems.dmx.oidc.configuration.di.ConfigurationModule_ProvideConfigurationFactory;
import systems.dmx.oidc.di.OidcComponent;
import systems.dmx.oidc.repository.StateRepository;
import systems.dmx.oidc.repository.StateRepository_Factory;
import systems.dmx.oidc.usecase.CreateOidcAccountManagerUseCase;
import systems.dmx.oidc.usecase.CreateOidcAccountManagerUseCase_Factory;
import systems.dmx.oidc.usecase.HandleOAuthCallbackUseCase;
import systems.dmx.oidc.usecase.HandleOAuthCallbackUseCase_Factory;
import systems.dmx.oidc.usecase.LogConfigurationUseCase;
import systems.dmx.oidc.usecase.LogConfigurationUseCase_Factory;

@DaggerGenerated
public final class DaggerOidcComponent {
    private DaggerOidcComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class OidcComponentImpl
    implements OidcComponent {
        private final CoreService coreService;
        private final OidcComponentImpl oidcComponentImpl = this;
        private Provider<ConfigurationDatasource> provideConfigurationDatasourceProvider;
        private Provider<ConfigurationRepository> configurationRepositoryProvider;
        private Provider<Configuration> provideConfigurationProvider;

        private OidcComponentImpl(CoreService coreServiceParam, AccessControlService accessControlServiceParam, AccountManagementService accountManagementServiceParam) {
            this.coreService = coreServiceParam;
            this.initialize(coreServiceParam, accessControlServiceParam, accountManagementServiceParam);
        }

        private void initialize(CoreService coreServiceParam, AccessControlService accessControlServiceParam, AccountManagementService accountManagementServiceParam) {
            this.provideConfigurationDatasourceProvider = DoubleCheck.provider((Provider)SystemPropertyConfigurationDatasource_Factory.create());
            this.configurationRepositoryProvider = ConfigurationRepository_Factory.create(this.provideConfigurationDatasourceProvider);
            this.provideConfigurationProvider = DoubleCheck.provider((Provider)ConfigurationModule_ProvideConfigurationFactory.create(this.configurationRepositoryProvider));
        }

        @Override
        public Configuration configuration() {
            return (Configuration)this.provideConfigurationProvider.get();
        }

        @Override
        public CreateOidcAccountManagerUseCase createOidcAccountManagerUseCase() {
            return CreateOidcAccountManagerUseCase_Factory.newInstance(StateRepository_Factory.newInstance());
        }

        @Override
        public LogConfigurationUseCase logConfigurationUseCase() {
            return LogConfigurationUseCase_Factory.newInstance();
        }

        @Override
        public HandleOAuthCallbackUseCase handleOAuthCallbackUseCase() {
            return HandleOAuthCallbackUseCase_Factory.newInstance(StateRepository_Factory.newInstance(), this.coreService);
        }

        @Override
        public StateRepository ongoingAuthorizations() {
            return StateRepository_Factory.newInstance();
        }
    }

    public static final class Builder {
        private CoreService coreService;
        private AccessControlService accessControlService;
        private AccountManagementService accountManagementService;

        private Builder() {
        }

        public Builder coreService(CoreService coreService) {
            this.coreService = (CoreService)Preconditions.checkNotNull((Object)coreService);
            return this;
        }

        public Builder accessControlService(AccessControlService accessControlService) {
            this.accessControlService = (AccessControlService)Preconditions.checkNotNull((Object)accessControlService);
            return this;
        }

        public Builder accountManagementService(AccountManagementService accountManagementService) {
            this.accountManagementService = (AccountManagementService)Preconditions.checkNotNull((Object)accountManagementService);
            return this;
        }

        public OidcComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.coreService, CoreService.class);
            Preconditions.checkBuilderRequirement((Object)this.accessControlService, AccessControlService.class);
            Preconditions.checkBuilderRequirement((Object)this.accountManagementService, AccountManagementService.class);
            return new OidcComponentImpl(this.coreService, this.accessControlService, this.accountManagementService);
        }
    }
}

