/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.manager;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.State;
import java.io.IOException;
import java.net.URI;
import systems.dmx.accountmanagement.AccountManager;
import systems.dmx.accountmanagement.CheckCredentialsResult;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.oidc.manager.AuthorizationCodeFlow;
import systems.dmx.oidc.manager.PasswordGrantFlow;
import systems.dmx.oidc.repository.StateRepository;

public class OidcAccountManager
implements AccountManager {
    public static final String NAME_PREFIX = "OIDC:";
    private final String name;
    private final StateRepository ongoingAuthorizations;
    private final PasswordGrantFlow passwordGrantFlow;
    private final AuthorizationCodeFlow authorizationCodeFlow;

    public OidcAccountManager(String providerId, StateRepository ongoingAuthorizations, PasswordGrantFlow passwordGrantFlow, AuthorizationCodeFlow authorizationCodeFlow) {
        this.name = NAME_PREFIX + providerId;
        this.ongoingAuthorizations = ongoingAuthorizations;
        this.passwordGrantFlow = passwordGrantFlow;
        this.authorizationCodeFlow = authorizationCodeFlow;
    }

    public boolean canProvideAuthRequestUri() {
        return this.authorizationCodeFlow != null;
    }

    public URI newAuthRequestUri() {
        State state = this.ongoingAuthorizations.addAuthorization(this.authorizationCodeFlow::handleCallback);
        return this.authorizationCodeFlow.getAuthRequestUri(state);
    }

    public String name() {
        return this.name;
    }

    public void createAccount(Credentials credentials) {
        throw new RuntimeException("Not supported");
    }

    public void changePassword(Credentials credentials, Credentials credentials1) {
        throw new RuntimeException("Not supported");
    }

    public void onUsernameDeleted(String s) {
    }

    public CheckCredentialsResult checkCredentials(Credentials credentials) {
        try {
            return this.passwordGrantFlow.login(credentials.username, credentials.password) ? CheckCredentialsResult.lookupOrCreationRequired() : CheckCredentialsResult.failed();
        }
        catch (ParseException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

