/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.usecase;

import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import systems.dmx.oidc.configuration.Configuration;

public class LogConfigurationUseCase {
    private static final Logger logger = Logger.getLogger(LogConfigurationUseCase.class.getName());

    @Inject
    LogConfigurationUseCase() {
    }

    public void invoke(Configuration configuration) {
        logger.info("DMX OIDC Plugin Configuration:");
        List providerIds = configuration.providerConfigurations.stream().map(it -> it.id).collect(Collectors.toList());
        logger.info(String.format("Configured identity providers: %s", providerIds));
        configuration.providerConfigurations.forEach(this::logProviderConfiguration);
    }

    private void logProviderConfiguration(Configuration.ProviderConfiguration providerConfiguration) {
        logger.info(String.format("\nProvider Id: %s\nAuthorization Endpoint: %s\nToken Endpoint: %s\nClient Id: %s\nClient Secret: %s\nAdministration Type: %s", new Object[]{providerConfiguration.id, providerConfiguration.authorizationEndpoint, providerConfiguration.tokenEndpoint, providerConfiguration.clientId, providerConfiguration.clientSecret, providerConfiguration.administrationType}));
    }
}

