/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.configuration;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import systems.dmx.oidc.configuration.AdministrationType;
import systems.dmx.oidc.configuration.Configuration;
import systems.dmx.oidc.configuration.ConfigurationDatasource;
import systems.dmx.oidc.configuration.Identifier;

public class ConfigurationRepository {
    private final ConfigurationDatasource datasource;

    @Inject
    ConfigurationRepository(ConfigurationDatasource datasource) {
        this.datasource = datasource;
    }

    public Configuration parseConfiguration() {
        String dmxHostUrl = this.datasource.getString(Identifier.DMX_HOST_URL.key);
        String appHomeUrl = this.datasource.getString(Identifier.APP_HOME_URL.key);
        List<String> providerIds = this.datasource.getStringList(Identifier.PROVIDERS.key);
        List<Configuration.ProviderConfiguration> providerConfigurations = providerIds.stream().map(this::parseProviderConfiguration).filter(Objects::nonNull).collect(Collectors.toList());
        return new Configuration(dmxHostUrl, appHomeUrl, providerConfigurations);
    }

    @Nullable
    private Configuration.ProviderConfiguration parseProviderConfiguration(String providerId) {
        String authorizationEndpoint = this.datasource.getString(Identifier.AUTHORIZATION_ENDPOINT.getKey(providerId), Identifier.AUTHORIZATION_ENDPOINT.defaultValue);
        String tokenEndpoint = this.datasource.getString(Identifier.TOKEN_ENDPOINT.getKey(providerId), Identifier.TOKEN_ENDPOINT.defaultValue);
        String clientId = this.datasource.getString(Identifier.CLIENT_ID.getKey(providerId), Identifier.CLIENT_ID.defaultValue);
        String clientSecret = this.datasource.getString(Identifier.CLIENT_SECRET.getKey(providerId), Identifier.CLIENT_SECRET.defaultValue);
        AdministrationType administrationType = AdministrationType.fromStringOrNone(this.datasource.getString(Identifier.ADMINISTRATION_TYPE.getKey(providerId), Identifier.TOKEN_ENDPOINT.defaultValue));
        return tokenEndpoint != null && clientId != null && clientSecret != null ? new Configuration.ProviderConfiguration(providerId, authorizationEndpoint, tokenEndpoint, clientId, clientSecret, administrationType) : null;
    }
}

