/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.manager;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import systems.dmx.oidc.configuration.Configuration;

public class AuthorizationCodeFlow {
    private static final Logger logger = Logger.getLogger(AuthorizationCodeFlow.class.getName());
    private final URI appRedirectUri;
    private final URI authorizationEndpoint;
    private final URI tokenEndpoint;
    private final ClientID clientID;
    private final Secret clientSecret;

    public AuthorizationCodeFlow(String appRedirectUri, Configuration.ProviderConfiguration providerConfiguration) throws URISyntaxException {
        this.appRedirectUri = new URI(appRedirectUri);
        this.authorizationEndpoint = new URI(providerConfiguration.authorizationEndpoint);
        this.tokenEndpoint = new URI(providerConfiguration.tokenEndpoint);
        this.clientID = new ClientID(providerConfiguration.clientId);
        this.clientSecret = new Secret(providerConfiguration.clientSecret);
    }

    URI getAuthRequestUri(State state) {
        AuthorizationRequest authRequest = new AuthorizationRequest.Builder(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), this.clientID).endpointURI(this.authorizationEndpoint).scope(new Scope(new Scope.Value[]{OIDCScopeValue.OPENID, OIDCScopeValue.PROFILE})).state(state).redirectionURI(this.appRedirectUri).build();
        return authRequest.toURI();
    }

    Tokens handleCallback(String authorizationCode) throws IOException, ParseException, java.text.ParseException {
        TokenRequest tokenRequest = new TokenRequest(this.tokenEndpoint, (ClientAuthentication)new ClientSecretBasic(this.clientID, this.clientSecret), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode(authorizationCode), this.appRedirectUri));
        TokenResponse tokenResponse = TokenResponse.parse((HTTPResponse)tokenRequest.toHTTPRequest().send());
        logger.info(String.format("token response code: %s - mesage: %s", tokenResponse.toHTTPResponse().getStatusCode(), tokenResponse.toHTTPResponse().getStatusMessage()));
        if (tokenResponse.indicatesSuccess()) {
            return tokenResponse.toSuccessResponse().getTokens();
        }
        return null;
    }
}

