/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.manager;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import systems.dmx.oidc.configuration.Configuration;

public class PasswordGrantFlow {
    private static final Logger logger = Logger.getLogger(PasswordGrantFlow.class.getName());
    private final URI tokenEndpoint;
    private final ClientID clientID;
    private final Secret clientSecret;

    public PasswordGrantFlow(Configuration.ProviderConfiguration providerConfiguration) throws URISyntaxException {
        this.tokenEndpoint = new URI(providerConfiguration.tokenEndpoint);
        this.clientID = new ClientID(providerConfiguration.clientId);
        this.clientSecret = new Secret(providerConfiguration.clientSecret);
    }

    public boolean login(String username, String password) throws IOException, ParseException {
        ClientSecretBasic clientAuth = new ClientSecretBasic(this.clientID, this.clientSecret);
        ResourceOwnerPasswordCredentialsGrant passwordGrant = new ResourceOwnerPasswordCredentialsGrant(username, new Secret(password));
        TokenRequest request = new TokenRequest(this.tokenEndpoint, (ClientAuthentication)clientAuth, (AuthorizationGrant)passwordGrant, new Scope(new Scope.Value[]{OIDCScopeValue.OPENID}));
        TokenResponse response = TokenResponse.parse((HTTPResponse)request.toHTTPRequest().send());
        if (response.indicatesSuccess()) {
            AccessTokenResponse successResponse = (AccessTokenResponse)response;
            AccessToken accessToken = successResponse.getTokens().getAccessToken();
            RefreshToken refreshToken = successResponse.getTokens().getRefreshToken();
            logger.info("Access Token: " + accessToken.getValue());
            logger.info("Refresh Token: " + (refreshToken != null ? refreshToken.getValue() : "Kein Refresh Token"));
            return true;
        }
        TokenErrorResponse errorResponse = response.toErrorResponse();
        logger.info("Fehler: " + errorResponse.getErrorObject().getDescription());
        return false;
    }
}

