/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.usecase;

import com.nimbusds.oauth2.sdk.util.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import systems.dmx.oidc.configuration.Configuration;
import systems.dmx.oidc.manager.AuthorizationCodeFlow;
import systems.dmx.oidc.manager.OidcAccountManager;
import systems.dmx.oidc.manager.PasswordGrantFlow;
import systems.dmx.oidc.repository.StateRepository;

@Singleton
public class CreateOidcAccountManagerUseCase {
    private final StateRepository ongoingAuthorizations;

    @Inject
    CreateOidcAccountManagerUseCase(StateRepository stateRepository) {
        this.ongoingAuthorizations = stateRepository;
    }

    @Nullable
    public OidcAccountManager invoke(Configuration configuration, Configuration.ProviderConfiguration providerConfiguration) {
        String appRedirectUri = String.format("%s/oidc/callback", configuration.dmxHostUrl);
        try {
            AuthorizationCodeFlow authorizationCodeFlow = StringUtils.isNotBlank((CharSequence)providerConfiguration.authorizationEndpoint) ? new AuthorizationCodeFlow(appRedirectUri, providerConfiguration) : null;
            PasswordGrantFlow passwordGrantFlow = StringUtils.isNotBlank((CharSequence)providerConfiguration.tokenEndpoint) ? new PasswordGrantFlow(providerConfiguration) : null;
            return new OidcAccountManager(providerConfiguration.id, this.ongoingAuthorizations, passwordGrantFlow, authorizationCodeFlow, new URI(configuration.appHomeUrl));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

