/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.accountmanagement.AccountManagementService;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.oidc.OidcService;
import systems.dmx.oidc.configuration.Configuration;
import systems.dmx.oidc.di.DaggerOidcComponent;
import systems.dmx.oidc.di.OidcComponent;
import systems.dmx.oidc.manager.OidcAccountManager;
import systems.dmx.oidc.usecase.CreateOidcAccountManagerUseCase;
import systems.dmx.oidc.usecase.HandleOAuthCallbackUseCase;
import systems.dmx.oidc.usecase.LogConfigurationUseCase;

@Path(value="/oidc")
public class OidcPlugin
extends PluginActivator
implements OidcService {
    private OidcComponent component;
    private static final Logger logger = Logger.getLogger(OidcPlugin.class.getName());
    @Inject
    private AccessControlService accessControlService;
    @Inject
    private AccountManagementService accountManagementService;
    @Context
    private HttpServletRequest request;
    private Configuration configuration;
    HandleOAuthCallbackUseCase handleOAuthCallbackUseCase;
    private List<OidcAccountManager> accountManagerList = Collections.emptyList();

    public void serviceArrived(Object service) {
    }

    public void serviceGone(Object service) {
        if (service instanceof AccountManagementService) {
            this.accountManagerList.forEach(arg_0 -> ((AccountManagementService)this.accountManagementService).unregisterAccountManager(arg_0));
        }
    }

    public void init() {
        this.component = DaggerOidcComponent.builder().accessControlService(this.accessControlService).coreService(this.dmx).accountManagementService(this.accountManagementService).build();
        this.configuration = this.component.configuration();
        this.handleOAuthCallbackUseCase = this.component.handleOAuthCallbackUseCase();
        LogConfigurationUseCase logConfigurationUseCase = this.component.logConfigurationUseCase();
        logConfigurationUseCase.invoke(this.configuration);
        CreateOidcAccountManagerUseCase createOidcAccountManagerUseCase = this.component.createOidcAccountManagerUseCase();
        this.accountManagerList = this.configuration.providerConfigurations.stream().map(providerConfiguration -> createOidcAccountManagerUseCase.invoke(this.configuration, (Configuration.ProviderConfiguration)providerConfiguration)).filter(Objects::nonNull).collect(Collectors.toList());
        this.accountManagerList.forEach(arg_0 -> ((AccountManagementService)this.accountManagementService).registerAccountManager(arg_0));
    }

    @GET
    @Path(value="/authorize")
    public Response authorize(@QueryParam(value="providerKey") String providerKey) {
        AtomicReference<Object> requestUri = new AtomicReference<Object>(null);
        this.accountManagerList.forEach(oidcAccountManager -> {
            if (oidcAccountManager.name().contains(providerKey)) {
                requestUri.set(oidcAccountManager.newAuthRequestUri());
            }
        });
        return requestUri.get() != null ? Response.status((Response.Status)Response.Status.TEMPORARY_REDIRECT).location((URI)requestUri.get()).build() : Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/callback")
    public Response callback(@QueryParam(value="code") String authorizationCode, @QueryParam(value="state") String state) {
        URI appHomeUri = this.handleOAuthCallbackUseCase.invoke(this.request, authorizationCode, state);
        return Response.status((Response.Status)Response.Status.TEMPORARY_REDIRECT).location(appHomeUri).build();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }
}

