/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.manager;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.Tokens;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import systems.dmx.accountmanagement.AccountManager;
import systems.dmx.accountmanagement.CheckCredentialsResult;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.oidc.manager.AuthorizationCodeFlow;
import systems.dmx.oidc.manager.PasswordGrantFlow;
import systems.dmx.oidc.repository.StateRepository;

public class OidcAccountManager
implements AccountManager {
    public static final String NAME_PREFIX = "OIDC:";
    private final String name;
    private final StateRepository ongoingAuthorizations;
    private final PasswordGrantFlow passwordGrantFlow;
    private final AuthorizationCodeFlow authorizationCodeFlow;
    private final URI appHomeUri;

    public OidcAccountManager(String providerId, StateRepository ongoingAuthorizations, PasswordGrantFlow passwordGrantFlow, AuthorizationCodeFlow authorizationCodeFlow, URI appHomeUri) {
        this.name = NAME_PREFIX + providerId;
        this.ongoingAuthorizations = ongoingAuthorizations;
        this.passwordGrantFlow = passwordGrantFlow;
        this.authorizationCodeFlow = authorizationCodeFlow;
        this.appHomeUri = appHomeUri;
    }

    public boolean canProvideAuthRequestUri() {
        return this.authorizationCodeFlow != null;
    }

    public URI newAuthRequestUri() {
        State state = this.ongoingAuthorizations.addAuthorization(new StateRepository.Authorization(){

            @Override
            @Nullable
            public Tokens callback(String authorizationCode) throws IOException, ParseException, java.text.ParseException {
                return OidcAccountManager.this.authorizationCodeFlow.handleCallback(authorizationCode);
            }

            @Override
            public URI getAppHomeUri() {
                return OidcAccountManager.this.appHomeUri;
            }
        });
        return this.authorizationCodeFlow.getAuthRequestUri(state);
    }

    public String name() {
        return this.name;
    }

    public void createAccount(Credentials credentials) {
        throw new RuntimeException("Not supported");
    }

    public void changePassword(Credentials credentials, Credentials credentials1) {
        throw new RuntimeException("Not supported");
    }

    public void onUsernameDeleted(String s) {
    }

    public CheckCredentialsResult checkCredentials(Credentials credentials) {
        try {
            return this.passwordGrantFlow.login(credentials.username, credentials.password) ? CheckCredentialsResult.lookupOrCreationRequired() : CheckCredentialsResult.failed();
        }
        catch (ParseException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

