/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.repository;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.Tokens;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class StateRepository {
    private static final Logger logger = Logger.getLogger(StateRepository.class.getName());
    private final Map<String, Authorization> states = new HashMap<String, Authorization>();

    @Inject
    StateRepository() {
    }

    public State addAuthorization(@Nonnull Authorization authorization) {
        State state = new State();
        this.states.put(state.getValue(), authorization);
        return state;
    }

    @Nullable
    public Authorization removeAuthorization(State state) {
        logger.info("This state repository: " + this);
        logger.info("Removing state: " + state.getValue());
        return this.states.remove(state.getValue());
    }

    public static interface Authorization {
        @Nullable
        public Tokens callback(String var1) throws IOException, ParseException, java.text.ParseException;

        public URI getAppHomeUri();
    }
}

